package antipatterns;

import javax.naming.*;
import javax.naming.directory.*;
import java.util.*;

public class TestLDAP {
        final static String ldapServerName = "localhost";
        final static String rootdn = "cn=Manager, o=jndiTest";
        final static String rootpass = "secret";
        final static String rootContext = "o=jndiTest";
        
        public static void main( String[] args ) {
                // konfiguruje dostp do serwera
                
                Properties env = new Properties();
                
                env.put( Context.INITIAL_CONTEXT_FACTORY,
                         "com.sun.jndi.ldap.LdapCtxFactory" );
                env.put( Context.PROVIDER_URL, "ldap://" + ldapServerName + "/" + rootContext );
                env.put( Context.SECURITY_PRINCIPAL, rootdn );
                env.put( Context.SECURITY_CREDENTIALS, rootpass );
                
                try {
                    // pobiera pocztkowy kontekst katalogu ze rodowiska
                   DirContext ctx = new InitialDirContext(env);
                   DirContext people = (DirContext)ctx.lookup("ou=people");
                   
                   BasicAttributes mandatory = new BasicAttributes("cn", "schlomo");
                   mandatory.put("objectClass", "person");
                   mandatory.put("sn", "testa2");
                   mandatory.put("telephoneNumber", "555-1212");
                   
                   people.createSubcontext("cn=schlomo", mandatory);
                   
                   NamingEnumeration ne = people.list("");
                   while(ne.hasMore()) {
                        NameClassPair ncp = (NameClassPair)ne.next();
                        System.out.println("name: " + ncp.getName());
                   }
                   
                } catch ( NameAlreadyBoundException nabe ) {
                        System.err.println( "warto zostaa ju powizana!" );
                        nabe.printStackTrace();
                } catch ( Exception e ) {
                        System.err.println( e );
                }
        }
}
