package vhexample.view;

import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.net.*;

/**
 * Klasa parsujca informacje RSS z pliku 
 */
public class RSSInfo {
    /** znaczniki RSS dla kanau, elementu, tytuu i cza */
    private static final String CHANNEL_TAG = "channel";
    private static final String ITEM_TAG = "item";
    private static final String TITLE_TAG = "title";
    private static final String LINK_TAG = "link";
    
    /** wewntrzna reprezentacja elementu kanau w pliku XML */
    class Item {
        String title;
        String link;
    }
    
    /** wszystkie elementy pliku RSS */
    private Item[] items;
    
    /** informacja o kanale (w kadym pliku tylko jedna) */
    private Item channel;
    
    /**
     * Zwraca tytu kanau
     */
    public String getChannelTitle() {
        return channel.title;
    }
    
    /**
     * Zwraca cze zwizane z kanaem
     */
    public String getChannelLink() {
        return channel.link;
    }
    
    /**
     * Zwraca tytu elementu o podanym indeksie
     */
    public String getTitleAt(int index) {
        return items[index].title;
    }
    
    /**
     * Zwraca cze elementu o podanym indeksie
     */
    public String getLinkAt(int index) {
        return items[index].link;
    }
    
    /**
     * Zwraca liczb elementw
     */
    public int getItemCount() {
        return items.length;
    }
    
    /**
     * Parsuje plik RSS o podanym adresie URL
     */
    public void parse(String url) throws Exception {
        // czy si z adresem URL
        URLConnection uc = (new URL(url)).openConnection();
        
        // parsuje XML
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.parse(uc.getInputStream());
    
        // odnajduje element rss
        Element rss = doc.getDocumentElement();
        
        // parsuje kana
        NodeList rssList = rss.getElementsByTagName(CHANNEL_TAG);
        channel = new Item();
        Element channelElem = (Element)rssList.item(0);
        channel.title = getElementValue(channelElem, TITLE_TAG);
        channel.link = getElementValue(channelElem, LINK_TAG);
        
        // pobiera wszystkie elementy
        NodeList channelList = channelElem.getElementsByTagName(ITEM_TAG);
        items = new Item[channelList.getLength()];
        
        // parsuje kady element
        for (int i = 0; i < channelList.getLength(); i++) {
            Element cElem = (Element)channelList.item(i);
            items[i] = new Item();
            items[i].title = getElementValue(cElem, TITLE_TAG);
            items[i].link = getElementValue(cElem, LINK_TAG);
        }
    }
    
    /**
     * Odczytuje tekstow warto elementu pliku XML
     */
    private String getElementValue(Element parent, String child) 
        throws DOMException
    {
        // znajduje element podrzdny
        NodeList list = parent.getElementsByTagName(child);
        if (list == null || list.getLength() == 0) return null;
        
        Element childElem = (Element)list.item(0);
        
        // znajduje tekst elementu podrzdnego
        Node text = childElem.getFirstChild();
        if (text == null) return null;
        
        return text.getNodeValue();
    }
    
}

