package s2wexample.controller;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;

/**
 * Interfejs implementowany przez dyspozytora
 */
public interface Dispatcher {
    /**
     * Wywoywana przez kontener w celu okrelenia 
     * kontekstu serwletu zanim uyty zostanie dyspozytor.
     */
    public void setContext(ServletContext context) throws IOException;
    
    /**
     * Wywoywana gdy danie trafia do dyspozytora.
     *
     * @return adres URL nastpnej strony.
     */
    public String getNextPage(HttpServletRequest req);
}

