// Example 10-6: LockManager.java

package com.oreilly.patterns.chapter10;

import java.util.*;

public class LockManager {
  private HashMap locks;

  private static HashMap managers = new HashMap();

  /**
   * Zwraca menedera blokad o podanej nazwie. Jeli meneder taki nie zostanie
   * odnaleziony, to zostanie utworzony nowy meneder o takiej nazwie.
   */
  public static synchronized LockManager getLockManager(String managerName) {
    LockManager manager = (LockManager)managers.get(managerName);
    if(manager == null) {
        manager = new LockManager();
        managers.put(managerName, manager);
    }
    return manager;
  }

  /**
   * Tworzy now instancj klasy LockManager.
   */
  public LockManager() {
    locks = new HashMap();
  }

 /**
  * da blokady od podanej instancji klasy LockManager.
  */
  public boolean requestLock(String username, Object lockable) {
    if(username == null)
      return false; // lub mogaby wyrzuca wyjtek
      
    synchronized(locks) {
      if(!locks.containsKey(lockable)) {
        locks.put(lockable, username);
        return true;
      }
      // zwraca true, gdy ten uytkownik posiada ju blokad
      return (username.equals(locks.get(lockable)));
    }
  }

 /**
  * Zwalnia obiekt Lockable.
  */
  public Object releaseLock(Object lockable) {
    return locks.remove(lockable);
  }
}

