// Example 10-1: ConnectionManager.java

package com.oreilly.patterns.chapter10;

import java.sql.Connection;

public final class ConnectionManager
{
    private static final ThreadLocal currentConnection = new ThreadLocal();
     
    static Connection setConnection( Connection connection ) {
        Connection priorConnection = (Connection)currentConnection.get();
        currentConnection.set( connection );
        // Zwraca wczeniejsze poczenie jeli takie istnieje.
        // Wane jest, by wszystkie poczenia z baz danych
        // zostay poprawnie zamknite.
        return priorConnection;
    }
    
    public static Connection getConnection() {
        return (Connection)currentConnection.get();
    }
}
