
package pool;

import javax.xml.parsers.*;

/**
 * Fabryka parserw XML
 */
public class XMLParserFactory implements ResourceFactory {
    /** pojedyncza fabryka DocumentBuilderFactory */
    DocumentBuilderFactory dbf;
    
    /**
     * Konstruktor. Tworzy fabryk.
     */
    public XMLParserFactory() {
        dbf = DocumentBuilderFactory.newInstance();
    }
    
    /**
     * Tworzy nowy obiekt DocumentBuilder w celu dodania do puli
     */
    public Object createResource() {
        try {
            return dbf.newDocumentBuilder();
        } catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
    }
 
    /**
     * Sprawdza, czy obiekt DocumentBuilder jest poprawny.
     * Nadaje mu domylne wartoci atrybutw.
     */
    public boolean validateResource(Object o) {
        if (!(o instanceof DocumentBuilder)) {
            return false;
        }
        
        DocumentBuilder db = (DocumentBuilder) o;
        db.setEntityResolver(null);
        db.setErrorHandler(null);
        
        return true;
    }   
}

