

package pool;

import javax.xml.parsers.*;
import java.io.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Prosta klasa testujca pul zasobw
 */
public class PoolTest implements Runnable {
    /** domylna liczba wtkw i rozmiar puli */
    public static final int DEFAULT_THREAD_COUNT = 100;
    public static final int DEFAULT_POOL_SIZE = 100;
    
    /** najwiksza liczba wtkw, ktra dotychczas si pojawia */
    private int max_thread_count;
    
    /** rne zmienne zwizane z wtkami */
    private int started_thread_count;
    private int finished_thread_count;
    
    /** true, gdy praca zakoczona*/
    private boolean finished;
    
    /** true, jeli wystpi bd*/
    private boolean had_error;
    
    /** parser uywany dla testu bez puli */
    private DocumentBuilderFactory dbf;
    
    /** pula */
    private ResourcePool pool;
    
    /** Tworzy now instancj PoolTest */
    public PoolTest(int nthreads, int poolsize) {
        System.out.println("Czas = " + runPool(nthreads,poolsize));
    }
    
    /**
     * Testuje pul o okrelonym rozmiarze i dla danej liczby wtkw.  
     * Zwraca czas wykonania testu.
     */
    private long runPool(int nthreads, int poolsize) {
        // tworzy pul lub nie
        pool = new ResourcePool(new XMLParserFactory(), poolsize);
        //dbf = DocumentBuilderFactory.newInstance();
        
        
        // konfiguruje liczniki
        max_thread_count = nthreads;
        finished_thread_count = 0;
        finished = false;
        had_error = false;
    
        
        ThreadGroup group = new ThreadGroup("PoolTest");
        
        // tworzy wtki
        for (started_thread_count = 0;
             started_thread_count < max_thread_count;
             started_thread_count++) {
            (new Thread(group, this)).start();
        }
        
        long startTime = System.currentTimeMillis();
        
        // uruchamia wszystkie wtki naraz
        startCountNotify();
        
        // czeka do momentu zakoczenia wszystkich wtkw
        while(finished_thread_count < max_thread_count) {
            Thread.yield();
        }
        
        long totalTime = System.currentTimeMillis() - startTime;
        
        finishCountNotify();
        
        pool.destroy();
        if(had_error)
            return -1;
        
        return totalTime;
    }
    
    /**
     * Uruchamia pojedynczy wtek
     */
    public void run() {
        // czeka do momentu, gdy moliwe bdzie uruchomienie wtku
        startCountWait();
        
        try {
            // pobiera parser
            DocumentBuilder db = (DocumentBuilder) pool.getResource();
            //DocumentBuilder db = dbf.newDocumentBuilder();
            
            // parsuje
            if(!finished) {
                db.parse(new InputSource(new FileReader("long.xml")));
            }
        
            // zwraca zasb
            pool.returnResource(db);
        } catch(Throwable t) {
            System.out.println("Wystpi bd " + t.getMessage() +
                               " kocz dziaanie\n");
            had_error = true;
            finishCountNotify();
        } finally {
            finishCountWait();
        }
    }
    
    /**
     * Czeka do momentu, a wszystkie wtki s gotowe do uruchomienia
     */
    private synchronized void startCountWait() {
        while(started_thread_count < max_thread_count) {
            try { wait(); } catch(InterruptedException ie) {}
        }
    }
    
    /** 
     * Powiadamia wszystkie wtki o rozpoczciu testu
     */
    private synchronized void startCountNotify() {
        notifyAll();
    }
    
    /**
     * Czeka a wszystkie wtki zakocz przetwarzanie
     */
    private synchronized void finishCountWait() {
        finished_thread_count++;
        
        while(!finished) {
            try { wait(); } catch(InterruptedException ie) {}
        }
    }
    
    /**
     * Powiadamia wszystkie wtki, e mog zakoczy dziaanie
     */
    private synchronized void finishCountNotify() {
        finished = true;
        notifyAll();
    }
    
    /**
     * Wykonuje test dla liczby wtkw oraz rozmiaru puli 
     * okrelonych w wierszu polece.
     */
    public static void main(String[] args) {
        int nthreads = DEFAULT_THREAD_COUNT;
        int poolsize = DEFAULT_POOL_SIZE;
        
        if(args.length > 0) {
            nthreads = Integer.parseInt(args[0]);
        }
        
        if(args.length > 1) {
            poolsize = Integer.parseInt(args[1]);
        }
        
        if(nthreads <= 0 || poolsize <= 0) {
            System.out.println("Uruchamianie: PoolTest <liczba_wtkw>");
            System.exit(-1);
        }
        
        System.out.println("Test wykonywany dla  " + nthreads + " wtkw i " +
                           poolsize + " elementw w puli");
        
        PoolTest pt = new PoolTest(nthreads, poolsize);
    }
    
}

