package apexample.view;

import apexample.model.*;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

/**
 * Wasny znacznik reprezentujcy kana RSS.  Udostpnia dwie zmienne
 * skryptowe dla nazwy kanau i jego cza.  Uzywany przez zagniedone
 * znaczniki w celu znalezienie informacji dla kadego elementu kanau
 */
public class RSSChannelTag extends BodyTagSupport {
    /** nazwy zmiennych skryptowych */
    private static final String NAME_ATTR = "channelName";
    private static final String LINK_ATTR = "channelLink";
    
    /** adres URL strony RSS */
    private String url;
    
    /** parser RSS */
    private RSSInfo rssInfo;
       
    /**
     * Wywoywana dla atrybutu URL znacznika
     */
    public void setURL(String url) {
        this.url = url;
    }
    
    /**
     * wywoywana przez zagniedone znaczniki w celu posuenia
     * si parserem RSS 
     */
    protected RSSInfo getRSSInfo() { 
        return rssInfo;
    }
    
    /**
     * Rejestruje subskrybcj RSS
     */
    public int doStartTag() throws JspException {
        try {
            // tworzy subskrypcj
            RSSSubscriber rssSubs = RSSSubscriber.getInstance();
            
            // zwraca ostatnio sparsowane dane
            rssInfo = rssSubs.getInfo(url);
            
            // eksportuje zmienne skryptowe
            pageContext.setAttribute(NAME_ATTR, rssInfo.getChannelTitle());
            pageContext.setAttribute(LINK_ATTR, rssInfo.getChannelLink());
        } catch (Exception ex) {
            ex.printStackTrace();
            throw new JspException("Unable to parse " + url, ex);
        }
        return Tag.EVAL_BODY_INCLUDE;
    }
}

