package s2wexample.controller.actions;

import s2wexample.controller.*;
import s2wexample.model.*;
import javax.servlet.http.*;
import javax.servlet.*;

/**
 * Akcja okrelajca jzyk na podstawie wyboru dokonanego przez uytkownika
 */
public class LanguageAction implements Action {
    /** nazwa atrybutu dla elementu okrelajcego jzyk na stronie JSP */
    private static final String LANGUAGE_PARAM = "language";
    
    /**
     * Wykonuje akcj.  Nadaje warto waciwoci komponentu UserBean
     */
    public boolean performAction(HttpServletRequest req,
                                 ServletContext context)
    {
        // odczytuje parametr dania
        String language = req.getParameter(LANGUAGE_PARAM);
        
        // i nadaje warto odpowiedniemu polu komponentu
        HttpSession session = req.getSession();
        UserBean ub = (UserBean) session.getAttribute(LoginAction.USERBEAN_ATTR);
        ub.setLanguage(language);
        
        // akcja zakoczona pomylnie
        return true;
    }  
}

