// Listing 9.2: DelegateLoggingWrapper.java

package com.oreilly.patterns.chapter9;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;


final class DelegateLoggingWrapper {
    /**
     * Dekoruje obiekt penomocnika biznesowego za pomoca obiektu LoggingWrapperHandler. 
     * Obiekt ten implementuje wszystkie interfejsy implementowane
     * przez oryginalny obiekt
     * @param delegate obudowywany penomocnik biznesowy
     * @return obudowany penomocnik biznesowy
     */
    static Object decorate(Object delegate) {
        return Proxy.newProxyInstance(
            delegate.getClass().getClassLoader(),
            delegate.getClass().getInterfaces(),
            new LoggingWrapperHandler(delegate));
    }

    static final class LoggingWrapperHandler 
                       implements InvocationHandler {
        private final Object delegate;

        LoggingWrapperHandler(Object delegate) {
            this.delegate = delegate;
        }

        /** Wywouje metod oryginalnego obiektu, 
            ale najpierw wywietla informacje o niej. */
        public Object invoke(Object proxy, Method method, 
                             Object[] args)
            throws Throwable {
            System.out.println("Wywoana metoda penomocnika biznesowego: " +
                method.getName());

            if (args != null) {
                for (int i = 0; i < args.length; i++) {
                    System.out.print(args[i]); 
                    System.out.print(
                      (i < (args.length - 1)) ? "," : "\n");
                }
            }

            Object result = method.invoke(delegate, args);
            System.out.println("Wykonanie zakoczone bez wyjtku");

            return result;
        }
    }
}
