// Example 10-2: ConnectionFilter.java

package com.oreilly.patterns.chapter10;

import java.io.IOException;

import javax.servlet.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;

public class ConnectionFilter implements Filter {

    private DataSource dataSource = null;
    
    /**
     * Tworzy rdo danych na podstawie parametru zdefiniowanego w web.xml.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            InitialContext iCtx = new InitialContext();
            Context ctx = (Context) iCtx.lookup("java:comp/env");
            dataSource = (DataSource) 
              ctx.lookup(filterConfig.getInitParameter("JNDI_datasource"));
        } catch (Exception e) {
            ServletException se = new ServletException();
            // Usunicie znaku komentarza w wierszu poniej
            // uatwi uruchomienie przykadu dla JDK 1.4.
            // se.initCause(e); 
            throw se;
        }
    }

    public void destroy() {
    }

    /** Pobiera poczenie, wykonuje acuch filtrw i zwraca poczenie. 
     * */
    public void doFilter(ServletRequest request, ServletResponse response,
        FilterChain chain) throws IOException, ServletException {

        Connection con = null;
        
        try {
          con = dataSource.getConnection();
          
          // Wybiera poczenie i prbuje 
          // zamkn poprzednie
          Connection previousCon = ConnectionManager.setConnection(con);
          if(previousCon != null) 
            try { previousCon.close(); } catch (SQLException e) {}

          // Wykonuje pozostae filtry acucha.  
          chain.doFilter(request, response);
          
          // Na wszelki wypadek upewnia si, e poczenie
          // nie jest ju uywane.
          ConnectionManager.setConnection(null);
        } catch (SQLException e) {
          ServletException se = new ServletException(e);
          throw se;
        } finally {
          if (con != null)
            try { con.close(); } catch (SQLException e) {}
        }
    }
}
