package antipatterns.model;

import antipatterns.ejbs.*;

import java.util.*;
import javax.ejb.*;
import javax.rmi.*;
import javax.naming.*;
import javax.servlet.http.*;

public class AddressBookCommand implements PersonCommand {
    private static final String ADDRESSBOOK_ATTR = "addressBook";
    
    private String firstName;
    private String lastName;
    private String owner;
    
    private List people;
    
    private AddressBook addressBook;
    
    public AddressBookCommand(String owner) {
        this.owner = owner;
    }
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    
    public void initialize(HttpSession session) throws NamingException {
        addressBook = (AddressBook)session.getAttribute(owner + "-" + ADDRESSBOOK_ATTR);
        if (addressBook == null) {
            Hashtable properties = new Properties();
            //properties.put(Context.INITIAL_CONTEXT_FACTORY,
            //    "com.sun.jndi.cosnaming.CNCtxFactory");
            //properties.put(Context.PROVIDER_URL, "iiop://wgs97-74:1050");
            
            InitialContext ic = new InitialContext(properties);
            Object personRef = ic.lookup("ejb/AddressBook");
            
            AddressBookHome addressBookHome =
            (AddressBookHome)PortableRemoteObject.narrow(personRef,
            AddressBookHome.class);
            
            try {
                System.out.println("Tworzenie nowej ksiki: " + owner);
                addressBook = addressBookHome.create(owner);
                session.setAttribute(owner + "-" + ADDRESSBOOK_ATTR, addressBook);
            } catch(Exception ex) {
                ex.printStackTrace();
            }
        }
    }
    
    public void runCommand() throws NamingException {
        try {
            PeopleDTO peopleDto = addressBook.findByName(firstName, lastName);
            people = peopleDto.getPeople();
            
        } catch(Exception ex) {
            ex.printStackTrace();
            return;
        }
        
    }
    
    public List getPeople() {
        return people;
    }
}
