package antipatterns.controller;

import antipatterns.model.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import javax.naming.*;

public class PersonServlet extends HttpServlet {
    protected void doGet(HttpServletRequest request,
                         HttpServletResponse response)
    throws ServletException, IOException {
        String method = request.getParameter("method");
        if (method == null) method = "";
        
        PersonCommand personCommand = null;
        
        if (method.equalsIgnoreCase("create")) {
            String type = request.getParameter("type");
            if (type == null) type = "person";
            
            getServletContext().log("Tworzenie kolejnych pozycji...");
            try {  
                if (type.equalsIgnoreCase("address")) {
                    CreateAddressCommand cc = new CreateAddressCommand();
                    cc.initialize();
                    cc.runCommand();
                } else {
                    CreatePersonCommand cc = new CreatePersonCommand();
                    cc.initialize();
                    cc.runCommand();
                }
                
                getServletContext().log("Tworzenie pozycji zakoczone.");
            } catch(Exception ce) {
                ce.printStackTrace();
                throw new ServletException("Bd podczas tworzenia: " + ce, ce);
            }
        } else if (method.equalsIgnoreCase("reset")) {
            request.getSession().invalidate();
        } else if (method.equalsIgnoreCase("ejb")) {
            personCommand = new EJBPersonCommand();
        } else if (method.equalsIgnoreCase("ldap")) {
            personCommand = new LdapPersonCommand();
        } else if (method.equalsIgnoreCase("addressbook")) { 
            String owner = request.getParameter("owner");
            personCommand = new AddressBookCommand(owner);
        } else {
            personCommand = new EJBFacadePersonCommand();
        }
        
        if (personCommand == null) {
            return;
        }
        
        String firstName = request.getParameter("first");
        String lastName = request.getParameter("last");
        
        try {
            personCommand.setFirstName(firstName);
            personCommand.setLastName(lastName);
            
            getServletContext().log("Klasa: " + personCommand);
            
            personCommand.initialize(request.getSession());
            
            long startTime = System.currentTimeMillis();
            getServletContext().log("Odczyt rozpoczty o: " + startTime);
            
            personCommand.runCommand();
            
            long endTime = System.currentTimeMillis();
            getServletContext().log("Odczyt zakoczony o: " + endTime);
            getServletContext().log(((endTime - startTime) / 1000) +
                                    " sekund.");
            
            request.setAttribute("personCommand", personCommand);
        } catch(NamingException ne) {
            throw new ServletException("Bd podczas wykonania polecenia", ne);
        }
        
        RequestDispatcher dispatch =
            getServletContext().getRequestDispatcher("/PersonView.jsp");
        dispatch.forward(request, response);
    }
}
