
package pool;

/**
 * Interfejs implementowany przez fabryki, ktre generuj zasoby
 * umieszczane w puli
 */
public interface ResourceFactory {
    /**
     * Tworzy nowy zasb
     */
    public Object createResource();
    
    /**
     * Sprawdza istniejcy zasb wygenerowany przez fabryk.  Nadaje
     * wartoci domylne parametrom zasobu lub zwraca warto false,
     * gdy przywrcenie pocztkowego stanu zasobu nie jest moliwe.
     */
    public boolean validateResource(Object o);
}

