package s2wexample.controller.actions;

import s2wexample.controller.*;
import s2wexample.model.*;
import javax.servlet.http.*;
import javax.servlet.*;

/**
 * Akcja przywracajca stan pocztkowy
 */
public class RestartAction implements Action {
    /**
     * Wykonuje akcj.  Uniewania sesj i zastpuje 
     * komponent UserBean nowym.
     */
    public boolean performAction(HttpServletRequest req,
                                 ServletContext context)
    {
        // uniewania biec sesj
        req.getSession().invalidate();
     
        // tworzy now i dodaje do niej nowy komponent UserBean
        HttpSession session = req.getSession();
        UserBean ub = UserBeanFactory.newInstance();
        session.setAttribute(LoginAction.USERBEAN_ATTR, ub);
        
        return true;
    }
}

