package s2wexample.controller;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import s2wexample.model.*;

/**
 * Kontroler uywajcy dyspozytorw w celu okrelenia
 * strony, do ktrej naley przej.
 */
public class FrontController extends HttpServlet {
    /** atrybut sesji biecego dyspozytora */
    private static final String DISPATCHER_ATTR = "Dispatcher";
    
    /** przedrostek klas dyspozytorw */
    private static final String DISPATCHER_PREFIX = "s2wexample.controller.";
    
    /**
     * Obsuga da GET przekazana do wsplnej metody
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        process(request, response);
    }
    
    /**
     * Obsuga da POST przekazana do wsplnej metody
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        process(request, response);
    }
    
    /**
     * Obsuguje danie przekazujc je odpowiedniemu dyspozytorowi
     */
    protected void process(HttpServletRequest request, 
                           HttpServletResponse response)
        throws ServletException, IOException
    {
        HttpSession session = request.getSession();
        ServletContext context = getServletContext();
        
        // pobiera ostatni element dania (zapisany maymi literami)
        String reqPath = request.getPathInfo();
        reqPath = Character.toUpperCase(reqPath.charAt(1)) +
                                        reqPath.substring(2).toLowerCase();
        
        // odnajduje dyspozytora dla danej sesji    
        Dispatcher dispatcher =
            (Dispatcher) session.getAttribute(reqPath + DISPATCHER_ATTR);
        
        // jeli dyspozytor nie zosta odnaleziony, to tworzy go
        if (dispatcher == null) {
            String className = reqPath + "Dispatcher";
            try {
                Class c = Class.forName(DISPATCHER_PREFIX + className);
                dispatcher = (Dispatcher)c.newInstance();
            } catch (Exception ex) {
                throw new ServletException("Nie mona odnale klasy " + className, ex); 
            }
            
            dispatcher.setContext(context);
            session.setAttribute(reqPath + DISPATCHER_ATTR, dispatcher);
        }
        
        // dynamiczne dane nie mog by buforowane
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        
        // uywa dyspozytora do okrelenia kolejnej strony
        String nextPage = dispatcher.getNextPage(request);
        
        // przekazuje sterowanie do widoku
        RequestDispatcher forwarder = request.getRequestDispatcher("/" + nextPage);
        forwarder.forward(request, response);
    }
}
