package mvcexample.model;

/**
 * Implementacja interfejsu MailingBean uywajca zmiennych lokalnych
 * do przechowywania informacji.  Rzeczywista implementacja wykorzystywaaby
 * w tym celu odpowiedni mechanizm trwaoci.
 */
public class MailingBeanImpl implements MailingBean {
    // imi
    private String first;
    
    // nazwisko
    private String last;
    
    // adres poczty elektronicznej
    private String email;
    
    // biecy bd
    private String errorString;
    
    /**
     * Tworzy now instancj MailingBeanImpl
     */
    public MailingBeanImpl() {
    }
    
    /**
     * Zwraca imi
     */
    public String getFirst() {
        return first;
    }
   
    /**
     * Okrela imi
     */
    public void setFirst(String first) {
        this.first = first;
    }
    
    /**
     * Zwraca nazwisko
     */
    public String getLast() {
        return last;
    }
    
    /**
     * Okrela nazwisko
     */
    public void setLast(String last) {
        this.last = last;
    }
   
    /**
     * Zwraca adres poczty elektronicznej
     */
    public String getEmail() {
        return email;
    }
    
    /**
     * Okrela adres poczty elektronicznej
     */
    public void setEmail(String email) {
        this.email = email;
    }
    
    /**
     * Dodaje subskrypcj.  Sprawdza jedynie czy adres poczty elektronicznej
     * zawiera znak '@'.
     * Rzeczywista implementacja komunikowaaby si tutaj z serwerem listy subskrypcji.
     */
    public boolean doSubscribe() {
        if (getEmail().indexOf('@') == -1) {
            errorString = "niedozwolony adres poczty elelktronicznej";
            return false;
        } else {
            errorString = null;
            return true;
        }
    }
    
    /**
     * Zwraca komunikat o bdzie dla ostatniej prby dodania nowej subskrypcji.
     */
    public String getErrorString() {
        return errorString;
    }
}
