package decoratorexample.controller;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.IOException;

import decoratorexample.model.*;

/**
 * Prosta implementacja serwletu kontrolera.  Serwlet ten przejmuje
 * wszystkie dania dotyczce adresw URL rozpoczynajcych si od "/pages."  Usuwa
 * przedrostek "/pages" i przechodzi do nastpujcego po nim adresu.
 */
public class FrontController extends HttpServlet {
    // Parametry wsplne z login.jsp.  Musz by takie same jak
    // nazwy waciwoci w pliku JSP.
    public static final String USERNAME_PARAM = "username";
    public static final String PASSWORD_PARAM = "password";
    public static final String USERBEAN_ATTR = "userbean";
    public static final String CONTROLLER_PREFIX = "/pages";
    
    /**
     * Obsuga da get przekazana do wsplnej procedury
     */

    protected void doGet(HttpServletRequest request,
                         HttpServletResponse response)
        throws ServletException, IOException 
    {
        process(request, response);
    }
    
    /**
     * Obsuga da post przekazana do wsplnej metody
     */
    protected void doPost(HttpServletRequest request,
                          HttpServletResponse response)
        throws ServletException, IOException 
    {
        process(request, response);
    }
    
    /**
     * Wsplna metoda obsugi.  Sprawdza, czy uytkownik jest zalogowany.
     * Jeli nie, to skierowuje go do strony logowania, a w przeciwnym razie
     * do danej strony.
     */
    protected void process(HttpServletRequest request,
                           HttpServletResponse response)
        throws ServletException, IOException
    {
        // domylna nastpna strona

        String nextPage = request.getPathInfo();
        
        // komponent uytkownika dla danej sesji
        HttpSession session = request.getSession(true);
        UserBean userBean = (UserBean) session.getAttribute(USERBEAN_ATTR);
        
        if (userBean == null || !userBean.isLoggedIn()) {
            // odczytuje parametry dania
            String username = request.getParameter(USERNAME_PARAM);
            String password = request.getParameter(PASSWORD_PARAM);
            
            // jeli komponent uytkownika nie istnieje, tworzy go
            if (userBean == null) {
                userBean = UserBeanFactory.newInstance();
                session.setAttribute(USERBEAN_ATTR, userBean);
            }
            
            // zapamituje nazw uytkownika i haso
            userBean.setUsername(username);
            userBean.setPassword(password);
            
            // prba logowania
            boolean result = userBean.doLogin();
            
            // jeli nieudana, to kieruje do strony logowania
            if (!result) {
                nextPage = "/login.jsp";
            }
        }
                  
        // sprawdza czy plik jest w formacie XML
        // rozwizanie to naley zastpi oglniejszym
        // mechanizmem odwzorowywania typw plikw na wartoci nagwkw
        if (nextPage.endsWith(".xml")) {
            response.setHeader("XML-Encoded", "true");
        }
        
        // przekazuje sterowanie do danego widoku
        RequestDispatcher dispatcher = 
            getServletContext().getRequestDispatcher(nextPage);
        dispatcher.forward(request, response);	
    }    
}
