// Listing 9.6 - fasada sesji EJB

package com.oreilly.patterns.chapter9;

import javax.ejb.*;
import javax.naming.*;

public class SaleFacadeBean implements SessionBean {
    private SessionContext context;
    private LocalCustomerHome customerHome;
	private LocalItemHome itemHome;
	private LocalSalesRecordHome recordHome;
    
    public void setSessionContext(SessionContext aContext) {
        context=aContext;
    }
    
    public void ejbActivate() {}
    public void ejbPassivate() {}
    
    public void ejbRemove() {
        customerHome = null;
        itemHome = null;
        recordHome = null;
    }

    public void ejbCreate() {
        try {
            InitialContext ic = new InitialContext();
            customerHome = 
               (LocalCustomerHome)
               ic.lookup("java:comp/env/ejb/local/Customer");
            itemHome = 
               (LocalItemHome)
               ic.lookup("java:comp/env/ejb/local/Item");
            recordHome = 
               (LocalSalesRecordHome)
             ic.lookup("java:comp/env/ejb/local/Record");
        } catch(Exception ex) {
            throw new EJBException(
           "Bd podcz\as wyszukiwania obiektu home: " + ex, ex);
        }
    }

    public ReceiptDTO doSale(int itemNumbers[], int customerId) {    
        try {
           LocalCustomer cust =     
          customerHome.findByPrimaryKey(customerId);
      
           LocalItem items[] = new LocalItem[itemNumbers.length];
		for (int i = 0; i < itemNumbers.length; i++) {
               items[i] = itemHome.findByPrimaryKey(itemNumbers[i]);
           }
  
           LocalSalesRecord record = 
           recordHome.createRecord(items, cust);
		
           return (new ReceiptDTO(record));
	    } catch(Exception ex) {
        	throw new 
           EJBException("Bd podczas obsugi sprzeday: " + ex, ex);
        }
    }
}
