//
//  ICFSecondViewController.m
//  Print
//
//  Created by Kyle Richter on 4/2/12.
//  Copyright (c) 2012 Dragon Forged Software. All rights reserved.
//

#import "ICFSecondViewController.h"
#import <QuartzCore/QuartzCore.h>

@implementation ICFSecondViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = @"Przeglądarka";
        self.tabBarItem.image = [UIImage imageNamed:@"second"];
    }
    return self;
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [backButton setEnabled: [theWebView canGoBack]];
    [forwardButton setEnabled: [theWebView canGoForward]];
    
    [urlBarTextField becomeFirstResponder];
}



- (void)dealloc 
{
    [urlBarTextField release];
    [backButton release];
    [forwardButton release];
    [super dealloc];
}


- (void)viewDidUnload 
{
    [urlBarTextField release];
    urlBarTextField = nil;
    [backButton release];
    backButton = nil;
    [forwardButton release];
    forwardButton = nil;
    [super viewDidUnload];
}

- (IBAction)go:(id)sender
{
    NSString *urlString = [urlBarTextField text];
    
    //add http:// to string if user didnt type it
    if(![[urlString lowercaseString] hasPrefix:@"http://"])
    {
        urlString = [@"http://" stringByAppendingString: urlString];
    }
        
    NSURL *urlToLoad = [[NSURL alloc] initWithString:urlString];
    NSURLRequest *request = [[NSURLRequest alloc] initWithURL: urlToLoad];
    
    [theWebView loadRequest: request];
    
    [urlToLoad release];
    [request release];
    
    [urlBarTextField resignFirstResponder];

}

- (IBAction)back:(id)sender 
{
    [theWebView goBack];
}

- (IBAction)forward:(id)sender 
{
    [theWebView goForward];
}

- (IBAction)print:(id)sender 
{
    /*
     W wersji pre-release iOS 6 poniższy kod nie działa; nr: 11809539
     */
    
    UIPrintInteractionController *print = [UIPrintInteractionController sharedPrintController];
    print.delegate = self;
    UIPrintInfo *printInfo = [UIPrintInfo printInfo];
    printInfo.outputType = UIPrintInfoOutputGeneral;
    printInfo.jobName = @"Drukuj w iOS";
    printInfo.duplex = UIPrintInfoDuplexLongEdge;
    print.printInfo = printInfo;
    print.showsPageRange = YES;
    
    
    NSURL *requestURL = [[theWebView request] URL];
    NSError *error = nil;
    
    NSString *contentHTML = [NSString stringWithContentsOfURL:requestURL 
                                              encoding:NSASCIIStringEncoding
                                                 error:&error];
    
    UIMarkupTextPrintFormatter *textFormatter = [[UIMarkupTextPrintFormatter alloc] initWithMarkupText:contentHTML];
    textFormatter.startPage = 0;
    textFormatter.contentInsets = UIEdgeInsetsMake(36.0, 36.0, 36.0, 36.0); // półcalowe marginesy
    textFormatter.maximumContentWidth = 504;   // treść ma 6 cali szerokości z uwzględnieniem marginesów
    
    print.printFormatter = textFormatter;
    [textFormatter release];
    
    void (^completionHandler)(UIPrintInteractionController *,BOOL, NSError *) = ^(UIPrintInteractionController *print,BOOL completed, NSError *error)
    {
        if (!completed && error) 
        {
            NSLog(@"Błąd!");
        }
    };

    [print presentAnimated:YES completionHandler:completionHandler];
}


//Translates the screen image of a UIWebview into a PDF and prints it
- (IBAction)printPDF:(id)sender 
{
    UIPrintInteractionController *print = [UIPrintInteractionController sharedPrintController];
    print.delegate = self;
    UIPrintInfo *printInfo = [UIPrintInfo printInfo];
    printInfo.outputType = UIPrintInfoOutputGeneral;
    printInfo.jobName = @"Print for iOS";
    printInfo.duplex = UIPrintInfoDuplexLongEdge;
    print.printInfo = printInfo;
    print.showsPageRange = YES;
    
    UIGraphicsBeginImageContext(theWebView.bounds.size);
    [theWebView.layer renderInContext:UIGraphicsGetCurrentContext()];
    UIImage *image = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    
    print.printingItem = image;
    
    void (^completionHandler)(UIPrintInteractionController *,BOOL, NSError *) = ^(UIPrintInteractionController *print,BOOL completed, NSError *error)
    {
        if (!completed && error) 
        {
            NSLog(@"Błąd!");
        }
    };
    
    [print presentAnimated:YES completionHandler:completionHandler];
}

#pragma mark - Webview Delegate
- (void)webView:(UIWebView *)webView didFailLoadWithError:(NSError *)error
{
    
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Błąd"
                                                    message:[error localizedDescription] 
                                                   delegate:nil 
                                          cancelButtonTitle:@"Anuluj" 
                                          otherButtonTitles: nil];
    [alert show];
    [alert release];
}

- (void)webViewDidStartLoad:(UIWebView *)webView
{
    [backButton setEnabled: [webView canGoBack]];
    [forwardButton setEnabled: [webView canGoForward]];
}

#pragma mark - UIPrintInteractionControllerDelegate

- (void)printInteractionControllerWillPresentPrinterOptions:(UIPrintInteractionController *)printInteractionController
{
    NSLog(@"Kontroler drukowania zostanie wyświetlony");
}

- (void)printInteractionControllerDidPresentPrinterOptions:(UIPrintInteractionController *)printInteractionController
{
    NSLog(@"Kontroler drukowania został wyświetlony");
}

- (void)printInteractionControllerWillDismissPrinterOptions:(UIPrintInteractionController *)printInteractionController
{
    NSLog(@"Kontroler drukowania zostanie ukryty");
}

- (void)printInteractionControllerDidDismissPrinterOptions:(UIPrintInteractionController *)printInteractionController
{
    NSLog(@"Kontroler drukowania został ukryty");
}

- (void)printInteractionControllerWillStartJob:(UIPrintInteractionController *)printInteractionController
{
    NSLog(@"Kontroler drukowania rozpocznie zadanie");
}

- (void)printInteractionControllerDidFinishJob:(UIPrintInteractionController *)printInteractionController
{
    NSLog(@"Kontroler drukowania zakończył zadanie");
}


@end
