//
//  PHGGalleryViewController.m
//  PhotoGallery
//
//  Created by Joe Keeley on 6/4/13.
//  Copyright (c) 2013 ICF. All rights reserved.
//

#import "PHGGalleryViewController.h"
#import <AssetsLibrary/AssetsLibrary.h>
#import "PHGThumbCell.h"
#import "PHGSectionHeader.h"
#import "PHGSectionFooter.h"

//NSString *kThumbCell = @"kThumbCell"; // UICollectionViewCell storyboard id
//NSString *kSectionHeader = @"kSectionHeader"; //section header storyboard id
//NSString *kSectionFooter = @"kSectionFooter"; //section header storyboard id

@interface PHGGalleryViewController ()
@property (nonatomic, strong) NSMutableArray *assetArray;
@property (nonatomic, strong) NSMutableArray *assetGroupArray;
@property (nonatomic, strong) ALAssetsLibrary *assetsLibrary;
@property (nonatomic, strong) UICollectionViewFlowLayout *pageLayout;
@property (nonatomic, assign) BOOL displayingPageLayout;

@end

@implementation PHGGalleryViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)enumerateGroupAssetsForGroup:(ALAssetsGroup *)group
{
    NSInteger lastIndex = [group numberOfAssets] - 1;
    
    __block NSMutableArray *groupAssetArray = [[NSMutableArray alloc] init];
    
    void (^addAsset)(ALAsset*, NSUInteger, BOOL*) =
    ^(ALAsset* result, NSUInteger index, BOOL* stop)
    {
        if (result != nil)
        {
            [groupAssetArray addObject:result];
        }
        
        if (index == lastIndex) {
            [self.assetArray addObject:groupAssetArray];
        }
    };
    
    [group enumerateAssetsUsingBlock:addAsset];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    [self.collectionView setAllowsMultipleSelection:YES];
        
    self.assetArray = [[NSMutableArray alloc] init];
    self.assetGroupArray = [[NSMutableArray alloc] init];
    self.assetsLibrary = [[ALAssetsLibrary alloc] init];
    
    [self.assetsLibrary enumerateGroupsWithTypes:ALAssetsGroupAll
                      usingBlock:^(ALAssetsGroup *group, BOOL *stop) {
                          if (group) {
                              NSString *sectionTitle = [NSString stringWithFormat:@"%@ - %d",[group valueForProperty:ALAssetsGroupPropertyName], [group numberOfAssets]];
                              [self.assetGroupArray addObject:sectionTitle];
                              [self enumerateGroupAssetsForGroup:group];
                          }
                          else
                          {
                              [self.collectionView reloadData];
                          }
                      }
                    failureBlock:^(NSError *error){
                    }
     ];    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Collection View Data Source methods

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return [self.assetGroupArray count];
}

- (NSInteger)collectionView:(UICollectionView *)view numberOfItemsInSection:(NSInteger)section;
{
    NSArray *sectionAssets = self.assetArray[section];
    return [sectionAssets count];
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    UICollectionReusableView *supplementaryView = nil;
    
//    if ([kind isEqualToString:UICollectionElementKindSectionHeader]) {
//        PHGSectionHeader *sectionHeader = [collectionView dequeueReusableSupplementaryViewOfKind:kind withReuseIdentifier:kSectionHeader forIndexPath:indexPath];
//        
//        [sectionHeader.headerLabel setText:self.assetGroupArray[indexPath.section]];
//        
//        supplementaryView = sectionHeader;
//    }
//
//    if ([kind isEqualToString:UICollectionElementKindSectionFooter]) {
//        PHGSectionFooter *sectionFooter = [collectionView dequeueReusableSupplementaryViewOfKind:kind withReuseIdentifier:kSectionFooter forIndexPath:indexPath];
//        
//        NSString *footerString = [NSString stringWithFormat:@"...end of %@",self.assetGroupArray[indexPath.section]];
//        [sectionFooter.footerLabel setText:footerString];
//        
//        supplementaryView = sectionFooter;
//    }

    return supplementaryView;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)cv cellForItemAtIndexPath:(NSIndexPath *)indexPath;
{
    // we're going to use a custom UICollectionViewCell, which will hold an image and its label
    //
//    PHGThumbCell *cell = [cv dequeueReusableCellWithReuseIdentifier:kThumbCell forIndexPath:indexPath];

    PHGThumbCell *cell = nil;
    // make the cell's title the actual NSIndexPath value
    //cell.label.text = [NSString stringWithFormat:@"{%ld,%ld}", (long)indexPath.row, (long)indexPath.section];
    
    // load the image for this cell
    
    ALAsset *assetForPath = self.assetArray[indexPath.section][indexPath.row];
    if (self.displayingPageLayout) {
        ALAssetRepresentation *assetRep = [assetForPath defaultRepresentation];
        UIImage *assetImage = [UIImage imageWithCGImage:[assetRep fullScreenImage]];
        [cell.thumbImageView setImage:assetImage];
    } else
    {
        UIImage *assetThumb = [UIImage imageWithCGImage:[assetForPath thumbnail]];
        [cell.thumbImageView setImage:assetThumb];
    }
    
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    NSLog(@"Zaznaczono element");
}

#pragma mark - Action methods

- (IBAction)actionTapped:(id)sender
{
    self.pageLayout = [[UICollectionViewFlowLayout alloc] init];
    [self.pageLayout setScrollDirection:UICollectionViewScrollDirectionHorizontal];
    [self.pageLayout setItemSize:CGSizeMake(300, 300)];
    [self.collectionView setCollectionViewLayout:self.pageLayout animated:YES];
    self.displayingPageLayout = YES;  
}

@end
