//
//  ICFViewController.m
//  BackgroundTasks
//
//  Created by Joe Keeley on 11/24/12.
//  Copyright (c) 2012 Joe Keeley. All rights reserved.
//

#import "ICFViewController.h"
#import <MediaPlayer/MediaPlayer.h>

@interface ICFViewController ()
- (void)performBackgroundTask;
@end

@implementation ICFViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
        
    NSError *playerInitError = nil;

    NSString *audioPath =
    [[NSBundle mainBundle] pathForResource:@"16_audio"
                                    ofType:@"mp3"];

    NSURL *audioURL = [NSURL fileURLWithPath:audioPath];

    self.audioPlayer = [[AVAudioPlayer alloc]
                        initWithContentsOfURL:audioURL
                        error:&playerInitError];

    AVAudioSession *session = [AVAudioSession sharedInstance];

    NSError *activeError = nil;
    if (![session setActive:YES error:&activeError])
    {
        NSLog(@"Nie udało się ustawić aktywnej sesji audio!");
    }

    NSError *categoryError = nil;
    if (![session setCategory:AVAudioSessionCategoryPlayback
                       error:&categoryError])
    {
        NSLog(@"Nie udało się ustawić kategorii sesji audio!");
    }

}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)playBackgroundMusicTouched:(id)sender
{
    if ([self.audioPlayer isPlaying])
    {
        [self.audioPlayer stop];
        
        [self.audioButton setTitle:@"Odtwarzaj muzykę w tle"
                          forState:UIControlStateNormal];
        
    } else
    {
        UIImage *lockImage = [UIImage imageNamed:@"book_cover"];

        MPMediaItemArtwork *artwork =
        [[MPMediaItemArtwork alloc] initWithImage:lockImage];

        NSDictionary *mediaDict =
        @{
            MPMediaItemPropertyTitle: @"Dźwiękowe zadanie w tle",
            MPMediaItemPropertyMediaType: @(MPMediaTypeAnyAudio),
            MPMediaItemPropertyPlaybackDuration:
            @(self.audioPlayer.duration),
            MPNowPlayingInfoPropertyPlaybackRate: @1.0,
            MPNowPlayingInfoPropertyElapsedPlaybackTime:
            @(self.audioPlayer.currentTime),
            MPMediaItemPropertyAlbumArtist: @"Album",
            MPMediaItemPropertyArtist: @"Wykonawca",
            MPMediaItemPropertyArtwork: artwork };
        
        [self.audioPlayer play];

        [self.audioButton setTitle:@"Zatrzymaj muzykę w tle"
                          forState:UIControlStateNormal];

        [[MPNowPlayingInfoCenter defaultCenter]
         setNowPlayingInfo:mediaDict];

        [self becomeFirstResponder];

        [[UIApplication sharedApplication]
         beginReceivingRemoteControlEvents];
    }
}

- (IBAction)startBackgroundTaskTouched:(id)sender
{
    UIDevice* device = [UIDevice currentDevice];
    
    if (! [device isMultitaskingSupported])
    {
        NSLog(@"Wielozadaniowość nie jest obsługiwana na tym urządzeniu.");
        return;
    }
    
    [self.backgroundButton setEnabled:NO];
    NSString *buttonTitle =@"Zadanie działa w tle";
    
    [self.backgroundButton setTitle:buttonTitle
                           forState:UIControlStateNormal];
    
    dispatch_queue_t background =
    dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
    
    dispatch_async(background, ^{
        [self performBackgroundTask];
    });

}

- (void)performBackgroundTask
{
    __block NSInteger counter = 0;
    
    __block UIBackgroundTaskIdentifier bTask =
    [[UIApplication sharedApplication]
    beginBackgroundTaskWithExpirationHandler:
    ^{
        NSLog(@"Wywołano mechanizm w tle.");
        NSLog(@"Licznik: %d, ID zadania to %u.",counter,bTask);
        
        
        [[UIApplication sharedApplication]
        endBackgroundTask:bTask];
        
        bTask = UIBackgroundTaskInvalid;
    }];
    
    NSUserDefaults *userDefaults =
    [NSUserDefaults standardUserDefaults];

    NSInteger startCounter =
    [userDefaults integerForKey:kLastCounterKey];

    NSInteger twentyMins = 20 * 60;
    
    NSLog(@"Rozpoczęto zadanie w tle, ID zadania to %u.",bTask);
    for (counter = startCounter; counter<=twentyMins; counter++)
    {
        [NSThread sleepForTimeInterval:1];
        [userDefaults setInteger:counter
                          forKey:kLastCounterKey];
        
        [userDefaults synchronize];
        
        NSTimeInterval remainingTime =
        [[UIApplication sharedApplication] backgroundTimeRemaining];
        
        if (remainingTime == DBL_MAX) {
            NSLog(@"Przetworzono w tle %d. Cały czas na pierwszym planie.",
                  counter);
        } else {
            NSLog(@"Przetworzono w tle %d. Pozostały czas: %f",
                  counter,remainingTime);
        }
    }
    
    NSLog(@"Ukończone zadania w tle");

    [userDefaults setInteger:0
                      forKey:kLastCounterKey];

    [userDefaults synchronize];

    dispatch_sync(dispatch_get_main_queue(), ^{
        [self.backgroundButton setEnabled:YES];
        [self.backgroundButton setTitle:@"Rozpocznij zadanie w tle"
                               forState:UIControlStateNormal];
    });

    [[UIApplication sharedApplication] endBackgroundTask:bTask];
    bTask = UIBackgroundTaskInvalid;
}

@end
