//
//  PHGCustomFlowLayoutViewController.m
//  PhotoGallery
//
//  Created by Joe Keeley on 7/13/13.
//  Copyright (c) 2013 ICF. All rights reserved.
//

#import "PHGCustomFlowLayoutViewController.h"
#import <AssetsLibrary/AssetsLibrary.h>
#import "PHGThumbCell.h"
#import "PHGSectionHeader.h"
#import "PHGCustomFlowLayout.h"

NSString *kCustomThumbCell = @"kCustomThumbCell"; // UICollectionViewCell storyboard id
NSString *kCustomSectionHeader = @"kCustomSectionHeader"; //section header storyboard id

@interface PHGCustomFlowLayoutViewController ()
@property (nonatomic, strong) NSMutableArray *assetArray;
@property (nonatomic, strong) NSMutableArray *assetGroupArray;
@property (nonatomic, strong) ALAssetsLibrary *assetsLibrary;
@property (nonatomic, strong) UICollectionViewFlowLayout *pageLayout;
@end

@implementation PHGCustomFlowLayoutViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)enumerateGroupAssetsForGroup:(ALAssetsGroup *)group
{
    NSInteger lastIndex = [group numberOfAssets] - 1;
    
    __block NSMutableArray *groupAssetArray = [[NSMutableArray alloc] init];
    
    void (^addAsset)(ALAsset*, NSUInteger, BOOL*) =
    ^(ALAsset* result, NSUInteger index, BOOL* stop)
    {
        if (result != nil)
        {
            [groupAssetArray addObject:result];
        }
        
        if (index == lastIndex) {
            [self.assetArray addObject:groupAssetArray];
        }
    };
    
    [group enumerateAssetsUsingBlock:addAsset];
}


- (void)viewDidLoad
{
    [super viewDidLoad];
    [self.collectionView setCollectionViewLayout:[[PHGCustomFlowLayout alloc] init]];
    [self.collectionView registerNib:[UINib nibWithNibName:@"PHGSectionHeader" bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:kCustomSectionHeader];

    self.assetArray = [[NSMutableArray alloc] init];
    self.assetGroupArray = [[NSMutableArray alloc] init];
    self.assetsLibrary = [[ALAssetsLibrary alloc] init];
    
    [self.assetsLibrary enumerateGroupsWithTypes:ALAssetsGroupAll
                                      usingBlock:^(ALAssetsGroup *group, BOOL *stop) {
                                          if (group) {
                                              NSString *sectionTitle = [NSString stringWithFormat:@"%@ - %d",[group valueForProperty:ALAssetsGroupPropertyName], [group numberOfAssets]];
                                              [self.assetGroupArray addObject:sectionTitle];
                                              [self enumerateGroupAssetsForGroup:group];
                                          }
                                          else
                                          {
                                              [self.collectionView reloadData];
                                          }
                                      }
                                    failureBlock:^(NSError *error){
                                    }
     ];    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Collection view methods

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return [self.assetGroupArray count];
}

- (NSInteger)collectionView:(UICollectionView *)view numberOfItemsInSection:(NSInteger)section;
{
    NSArray *sectionAssets = self.assetArray[section];
    return [sectionAssets count];
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    PHGSectionHeader *sectionHeader = [collectionView dequeueReusableSupplementaryViewOfKind:kind withReuseIdentifier:kCustomSectionHeader forIndexPath:indexPath];
    
    [sectionHeader.headerLabel setText:self.assetGroupArray[indexPath.section]];
    
    return sectionHeader;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)cv cellForItemAtIndexPath:(NSIndexPath *)indexPath;
{
    PHGThumbCell *cell = [cv dequeueReusableCellWithReuseIdentifier:kCustomThumbCell forIndexPath:indexPath];
    
    ALAsset *assetForPath = self.assetArray[indexPath.section][indexPath.row];
    UIImage *assetThumb = [UIImage imageWithCGImage:[assetForPath thumbnail]];
    [cell.thumbImageView setImage:assetThumb];
    
    return cell;
}

@end
