/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>
#import "ModalAlertDelegate.h"
#import "ModalSheetDelegate.h"

#define COOKBOOK_PURPLE_COLOR	[UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) 	[[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]

@interface TestBedViewController : UIViewController
@end

@implementation TestBedViewController

// Wybierz z trzech przcisków opcji plus przycisk anuluj.
- (void) alertThree: (id) sender
{
    // Anuluj = 0, Pierwszy = 1, Drugi = 2, Trzeci = 3
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Tytuł" message:@"Komunikat" delegate:nil cancelButtonTitle:@"Anuluj" otherButtonTitles:@"Pierwszy", @"Drugi", @"Trzeci", nil]; 
    ModalAlertDelegate *delegate = [ModalAlertDelegate delegateWithAlert:alertView];
    NSLog(@"Wybrany przycisk: %d", [delegate show]);
}

// Tekstowe dane wejściowe.
- (void) alertText: (id) sender
{
    // OK = 1, Anuluj = 0
    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Jak masz na imię?" message:@"Proszę podaj swoje imię." delegate:nil cancelButtonTitle:@"Anuluj" otherButtonTitles:@"OK", nil];
    alertView.alertViewStyle = UIAlertViewStylePlainTextInput;
    ModalAlertDelegate *delegate = [ModalAlertDelegate delegateWithAlert:alertView];
    
    NSString *response = @"Bez obaw. Też się wstydzę.";
    if ([delegate show])
        response = [NSString stringWithFormat:@"Witaj %@", [alertView textFieldAtIndex:0].text];
    
    [[[UIAlertView alloc] initWithTitle:nil message:response delegate:nil cancelButtonTitle:nil otherButtonTitles:@"OK", nil] show];
}

// Podstawowy obiekt UIActionSheet.
- (void) actionBasic: (id) sender
{
    // Destrukcyjny = 0, Pierwszy = 1, Drugi = 2, Trzeci = 3, Anuluj = 4.
    UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:@"Tytuł" delegate:nil cancelButtonTitle:@"Anuluj" destructiveButtonTitle:@"Destrukcyjny" otherButtonTitles:@"Pierwszy", @"Drugi", @"Trzeci", nil];
    ModalSheetDelegate *msd = [ModalSheetDelegate delegateWithSheet:actionSheet];
    actionSheet.delegate = msd;
    
    int result = [msd showFromBarButtonItem:sender animated:YES];
    NSLog(@"Wybrany przycisk: %d", result);
}

// Obiekt UIActionSheet.
- (void) actionSheetLong: (id) sender
{
    UIActionSheet *actionSheet = [[UIActionSheet alloc] initWithTitle:nil delegate:nil cancelButtonTitle:@"Anuluj" destructiveButtonTitle:nil otherButtonTitles:@"Jeden", @"Dwa", @"Trzy", @"Cztery", @"Pięć", @"Sześć", @"Siedem", @"Osiem", @"Dziewięć", nil];
    ModalSheetDelegate *msd = [ModalSheetDelegate delegateWithSheet:actionSheet];
    actionSheet.delegate = msd;
    
    int result = [msd showFromBarButtonItem:sender animated:YES];
    NSLog(@"Wybrany przycisk: %d", result);
}

#pragma mark Przekierowanie na przykłady

- (void) alert: (id) sender
{
    [self alertText:sender];
}

- (void) action: (id) sender
{
    //[self actionBasic: sender];
    [self actionSheetLong:sender];
}

- (void) loadView
{
    [super loadView];
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.rightBarButtonItem = BARBUTTON(@"Komunikat", @selector(alert:));
    self.navigationItem.leftBarButtonItem = BARBUTTON(@"Akcja", @selector(action:));
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
	UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
    [application setStatusBarHidden:YES];
    [[UINavigationBar appearance] setTintColor:COOKBOOK_PURPLE_COLOR];
    
    
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	TestBedViewController *tbvc = [[TestBedViewController alloc] init];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:tbvc];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}