/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>

#define COOKBOOK_PURPLE_COLOR [UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) [[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]
#define NUMSTR(_aNumber_) [NSString stringWithFormat:@"%d", _aNumber_]

@interface NSMutableDictionary (Boolean)
- (BOOL) boolForKey: (NSString *) aKey;
- (void) setBool: (BOOL) boolValue ForKey: (NSString *) aKey;
@end

@implementation NSMutableDictionary (Boolean)
- (BOOL) boolForKey: (NSString *) aKey
{
    if (![self objectForKey:aKey]) return NO;
    
    id obj = [self objectForKey:aKey];
    
    if ([obj respondsToSelector:@selector(boolValue)])
        return [(NSNumber *)obj boolValue];
    
    return NO;
}

- (void) setBool: (BOOL) boolValue ForKey: (NSString *) aKey
{
    [self setObject:[NSNumber numberWithBool:boolValue] forKey:aKey];
}
@end

@interface TestBedViewController : UITableViewController
{
    NSArray *items;
    NSMutableDictionary *switchStates;
}
@end

@implementation TestBedViewController

- (NSInteger)numberOfSectionsInTableView:(UITableView *)aTableView 
{ 
	// Ta prosta tabela składa się tylko z pojedynczej sekcji
	return 1; 
}

- (NSInteger)tableView:(UITableView *)aTableView numberOfRowsInSection:(NSInteger)section 
{
	// Określenie liczby elementów znajdujących się w sekcji.
	return items.count;
}

- (void) toggleSwitch: (UISwitch *) aSwitch
{
    // Przypisanie wartości tag do contentView komórki.
    [switchStates setBool:aSwitch.isOn ForKey:NUMSTR(aSwitch.superview.tag)];
}

- (UITableViewCell *)tableView:(UITableView *)aTableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    // Wczytanie komórki z pliku nib.
	UITableViewCell *cell = [aTableView dequeueReusableCellWithIdentifier:@"CustomCell"];

    // Pobranie przełącznika i dodanie celu, o ile wystąpi potrzeba.
    UISwitch *switchView = (UISwitch *)[cell viewWithTag:99];
    if (![switchView allTargets].count)
        [switchView addTarget:self action:@selector(toggleSwitch:) forControlEvents:UIControlEventValueChanged];
    
	cell.textLabel.text = [items objectAtIndex:indexPath.row];
    
    // Poniższe polecenie umieść w komentarzu, a zobaczysz „złe" zachowanie.
    switchView.on = [switchStates boolForKey:NUMSTR(indexPath.row)];
    
    // Przypisanie wartości tag do contentView komórki.
    cell.contentView.tag = indexPath.row;
    
	return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath 
{
    // Udzielenie odpowiedzi na działania użytkownika.
    self.title = [items objectAtIndex:indexPath.row];
}

- (void) loadView
{
    [super loadView];
    items = [@"A*B*C*D*E*F*G*H*I*J*K*L*M*N*O*P*Q*R*S*T*U*V*W*X*Y*Z" componentsSeparatedByString:@"*"];
    
    [self.tableView registerNib:[UINib nibWithNibName:@"CustomCell" bundle:[NSBundle mainBundle]] forCellReuseIdentifier:@"CustomCell"];
    
    //self.tableView.backgroundColor = [UIColor clearColor];

    switchStates = [NSMutableDictionary dictionary];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
	UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
    [application setStatusBarHidden:NO];
    [[UINavigationBar appearance] setTintColor:COOKBOOK_PURPLE_COLOR];
    
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	TestBedViewController *tbvc = [[TestBedViewController alloc] init];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:tbvc];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}