# importuje biblioteki Pythona: DateTime, Serial, SQLite3 i Twitter
from datetime import datetime
import serial
import sqlite3
import twitter

# importuje modu os w celu wyczyszczenia okna terminala i uruchomienia programu
# w systemie Windows naley uy polecenia "cls"; w systemach Linux i OS X naley uy polecenia "clear"
import os
if sys.platform == "win32":
    os.system("cls")
else:
    os.system("clear")

# nawizuje poczenie z portem szeregowym; nazw URZDZENIE_SZEREGOWE naley zastpi
# nazw portu szeregowego, do ktrego podczono modu XBee (za pomoc przewodu FTDI)
XBeePort = serial.Serial('/dev/tty.URZDZENIE_SZEREGOWE', \
                         baudrate = 9600, timeout = 1)

# nawizuje poczenie z baz danych SQLite
sqlconnection = sqlite3.connect("tweetingbirdfeeder.sqlite3")

# tworzy kursor bazy danych
sqlcursor = sqlconnection.cursor()

# inicjalizuje obiekt interfejsu Twitter API
api = twitter.Api('klucz_konsumenta_OAuth', 'klucz_tajny_konsumenta_OAuth', \
                  'token_dostpu_OAuth', 'klucz_tajny_tokenu_dostpu_OAuth')

def transmit(msg):
    # uzyskuje i odpowiednio formatuje biec dat i godzin
    timestamp = datetime.now().strftime("%Y-%m-%d %H:%M:%S")

    # sprawdza rodzaj komunikatu i przypisuje odpowiednie parametry odpowiedzi
    if msg == "przylot":
        tweet = "Jaki ptak wyldowa na grzdzie!"
        table = "birdfeeding"
    if msg == "odlot":
        tweet = "Ptak odlecia z grzdy!"
        table = "birdfeeding"
    if msg == "dosyp":
        tweet = "Pojemnik na ziarno dla ptakw jest pusty."
        table = "seedstatus"
    if msg == "ziarnoWNormie":
        tweet = "Ziarno w karmniku zostao uzupenione."
        table = "seedstatus"

    print "%s - %s" % (timestamp.strftime("%Y-%m-%d %H:%M:%S"), tweet)

    # zapisuje odpowiednie zdarzenie w bazie danych SQLite
    try:
        sqlstatement = "INSERT INTO %s (id, time, event) \
        VALUES(NULL, \"%s\", \"%s\")" % (table, timestamp, msg)
        sqlcursor.execute(sqlstatement)
        sqlconnection.commit()
    except:
        print "Nie mona zapisa zdarzenia w bazie danych."
        pass

    # publikuje informacj na Twitterze
    try:
        status = api.PostUpdate(msg)
    except:
        print "Nie mona opublikowa postu na Twitterze"
        pass

# gwna ptla programu
try:
    while 1:
        # nasuchuje znakw przychodzcych (wysyanych przez modu radiowy XBee zainstalowany w karmniku)
        message = XBeePort.readline()

        # w zalenoci od rodzaju otrzymanego komunikatu
        # rejestruje odpowiednie zdarzenie w bazie danych i publikuje post na Twitterze
        if "przylot" in message:
            transmit("przylot")
        if "odlot" in message:
            transmit("odlot")
        if "dosyp" in message:
            transmit("dosyp")
        if "ziarnoWNormie" in message:
            transmit("ziarnoWNormie")

except KeyboardInterrupt:
    # przerywa program w momencie wykrycia nacinicia kombinacji klawiszy Ctrl+C
    print("\nProgram nasuchujcy komunikatw wierkajcego karmnika dla ptakw koczy prac.\n")
    sqlcursor.close()
    pass
