//START:includes
#include <NewSoftSerial.h>
//END:includes

//START:defines
#define FORCE_THRESHOLD 400
#define ONBOARD_LED      13
#define FORCE_SENSOR      0
//END:defines

//START:variables
// ustawia wtyki cyfrowe na potrzeby szeregowego wysyania/odbioru danych przez modu XBee
NewSoftSerial XBeeSerial = NewSoftSerial(2, 3);
int force_value  = 0;
byte force_state = 0;
//END: variables

//START:setup
void setup()
{
    // na potrzeby komunikatw diagnostycznych w oknie portu szeregowego
    Serial.begin(9600);

    // na potrzeby transmisji danych za porednictwem moduu XBee
    XBeeSerial.begin(9600);

    // ustawia wtyk dla wbudowanej diody LED
    pinMode(ONBOARD_LED, OUTPUT);
}
//END:setup
//START:SendDeliveryAlert
void SendDeliveryAlert(int force_value, int force_state)
{
    digitalWrite(ONBOARD_LED, force_state ? HIGH : LOW);
    if (force_state)
        Serial.print("Dostarczono przesyk, force_value=");
    else
        Serial.print("Zabrano przesyk, force_value=");
    Serial.println(force_value);
    XBeeSerial.println(force_value);
}
//END:SendDeliveryAlert
//START:main_loop
void loop() 
{
    // czeka sekund w kadej iteracji ptli
    delay(1000);

    // sprawdza napicie na wtyku FORCE_SENSOR
    force_value = analogRead(FORCE_SENSOR);

    switch (force_state)
    {
    case 0: // sprawdza, czy dostarczono paczk
        if (force_value >= FORCE_THRESHOLD)
        {
            force_state = 1;
            SendDeliveryAlert(force_value, force_state);
        }
        break;
    case 1: // sprawdza, czy zabrano paczk
        if (force_value < FORCE_THRESHOLD)
        {
            force_state = 0;
            SendDeliveryAlert(force_value, force_state);
        }
        break;
    }
}
//END:main_loop
