//START:includes
#include <CapSense.h>;
#include <NewSoftSerial.h>
//END:includes

//START:defines
#define ON_PERCH        1500
#define SEED             500
#define CAP_SENSE         30
#define ONBOARD_LED       13
#define PHOTOCELL_SENSOR   0
//END:defines
//START:variables
// ustawia wtyki cyfrowe na potrzeby szeregowego wysyania/odbioru danych przez modu XBee
NewSoftSerial XBeeSerial = NewSoftSerial(2, 3);
CapSense foil_sensor     = CapSense(10,7); // czujnik pojemnociowy
                                           // rezystor mostkujcy wtyki cyfrowe nr 10 i 7
                                           // przewd poczony z rezystorem od strony wtyku nr 7
int perch_value  = 0;
byte perch_state = 0;
int seed_value   = 0;
byte seed_state  = 0;
//END:variables

//START:setup
void setup()
{
    // na potrzeby komunikatw diagnostycznych w oknie portu szeregowego
    Serial.begin(9600);

    // na potrzeby transmisji danych za porednictwem moduu XBee
    XBeeSerial.begin(9600);

    // ustawia wtyk dla wbudowanej diody LED
    pinMode(ONBOARD_LED, OUTPUT);
}
//END:setup

//START:SendPerchAlert
void SendPerchAlert(int perch_value, int perch_state)
{
    digitalWrite(ONBOARD_LED, perch_state ? HIGH : LOW);
    if (perch_state)
    {
        XBeeSerial.println("przylot");
        Serial.print("Zdarzenie ldowania na grzdzie, perch_value=");
    }
    else
    {
        XBeeSerial.println("odlot");
        Serial.print("Zdarzenie opuszczenia grzdy, perch_value=");
    }
    Serial.println(perch_value);
}
//END:SendPerchAlert

//START:SendSeedAlert
void SendSeedAlert(int seed_value, int seed_state)
{
    digitalWrite(ONBOARD_LED, seed_state ? HIGH : LOW);
    if (seed_state)
    {
        XBeeSerial.println("dosyp");
        Serial.print("Uzupenij ziarno, seed_value=");
    }
    else
    {
        XBeeSerial.println("ziarnoWNormie");
        Serial.print("Karma uzupeniona, seed_value=");
    }
    Serial.println(seed_value);
}
//END:SendSeedAlert

//START:main_loop
void loop() {
    // czeka sekund w kadej iteracji ptli
    delay(1000);

    // sprawdza warto czujnika pojemnociowego na grzdzie
    perch_value = foil_sensor.capSense(CAP_SENSE);

    // sprawdza warto fotokomrki ledzcej poziom ziarna
    seed_value = analogRead(PHOTOCELL_SENSOR);

    switch (perch_state)
    {
    case 0: // aden ptak nie siedzi na grzdzie
        if (perch_value >= ON_PERCH)
        {
            perch_state = 1;
            SendPerchAlert(perch_value, perch_state);
        }
        break;
    case 1: // jaki ptak siedzi teraz na grzdzie
        if (perch_value < ON_PERCH)
        {
            perch_state = 0;
            SendPerchAlert(perch_value, perch_state);
        }
        break;
    }

    switch (seed_state)
    {
    case 0: // pojemnik na ziarno zosta napeniony
        if (seed_value >= SEED)
        {
            seed_state = 1;
            SendSeedAlert(seed_value, seed_state);
        }
        break;
    case 1: // pojemnik na ziarno jest pusty
        if (seed_value < SEED)
        {
            seed_state = 0;
            SendSeedAlert(seed_value, seed_state);
        }
        break;
    }
}
//END:main_loop
