/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import org.apache.harmony.awt.datatransfer.DTK;

public final class ContextStorage {
    private volatile boolean shutdownPending = false;
    private static final ContextStorage globalContext = new ContextStorage();
    private Toolkit toolkit;
    private DTK dtk;
    private GraphicsEnvironment graphicsEnvironment;
    private final Object contextLock = new ContextLock();

    public static void setDefaultToolkit(Toolkit newToolkit) {
        ContextStorage.getCurrentContext().toolkit = newToolkit;
    }

    public static Toolkit getDefaultToolkit() {
        return ContextStorage.getCurrentContext().toolkit;
    }

    public static void setDTK(DTK dtk) {
        ContextStorage.getCurrentContext().dtk = dtk;
    }

    public static DTK getDTK() {
        return ContextStorage.getCurrentContext().dtk;
    }

    public static Object getContextLock() {
        return ContextStorage.getCurrentContext().contextLock;
    }

    public static GraphicsEnvironment getGraphicsEnvironment() {
        return ContextStorage.getCurrentContext().graphicsEnvironment;
    }

    public static void setGraphicsEnvironment(GraphicsEnvironment environment) {
        ContextStorage.getCurrentContext().graphicsEnvironment = environment;
    }

    private static ContextStorage getCurrentContext() {
        return globalContext;
    }

    public static boolean shutdownPending() {
        return ContextStorage.getCurrentContext().shutdownPending;
    }

    void shutdown() {
    }

    private class ContextLock {
        private ContextLock() {
        }
    }
}

