#include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
#include <ESP8266WebServer.h>  // serwer WWW z obsługą żądań HTTP GET i POST
#include <ESP8266mDNS.h>       // włącz obsługę multicast DNS
#include "DHT.h"               // i czujnika DHT

#define serialSpeed 115200     // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define DHTPIN 2      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

ESP8266WebServer Server(80); // obiekt serwera WWW na porcie 80

char* mDNS_host = "esp8266"; // nazwa hosta w sieci lokalnej

// kod HTML strony startowej zapisany w pamięci programu (nie w pamięci RAM)
const char page_index[] PROGMEM = R"=====(
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Mój Smart Home</title>
<style>
body { padding: 2rem; }
h1 { font-size: 2rem; }
h2 { font-size: 1rem; }
.item { font-size: 2.5rem; }
.item .unit { font-size: 1.0rem; margin-left: 5px; }
</style>
</head>
<body>
<h1>Mój Smart Home</h1>
<h2>Pomiar temperatury i wilgotności</h2>
<p class="item">Temperatura <span id="temp">0.0</span><sup class="unit">°C</sup></p>
<p class="item">Wilgotność <span id="hmd">0.0</span><sup class="unit">%</sup></p>
<hr>
<p><button onclick="getData()">Odczyt danych</button></p>
</body>
<script>
function getData(){
 var xhttp = new XMLHttpRequest();
 xhttp.onreadystatechange = function(){
  if (this.readyState == 4 && this.status == 200){
    data = this.responseText;
    data = data.split(',');
    document.getElementById('temp').innerHTML = data[0];
    document.getElementById('hmd').innerHTML = data[1];
  }
 };
 xhttp.open('GET', '/data', true);
 xhttp.send();
};
getData();
</script>
</html>
)=====";

void setup() 
{
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin();
  Serial.println(F("gotowe!"));

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  // aktywuj usługę multicast DNS
  if (MDNS.begin(mDNS_host)) { 
    Serial.println(F("Usługa mDNS aktywna."));
  }

  // uruchom serwer WWW
  Server.begin();
  Serial.println(F("Serwer WWW uruchomiony."));
  Serial.println(F("Otwórz w przeglądarce jeden z poniższych adresów URL:"));
  Serial.print(F("=> http://"));
  Serial.println(WiFi.localIP());
  Serial.print(F("=> http://"));
  Serial.print(mDNS_host);
  Serial.println(F(".local"));

  // obsługa adresów URL
  Server.on("/", handleRoot);        // URL strony głównej
  Server.on("/data", handleData);    // URL do odczytu temperatury
  Server.onNotFound(handleNotFound); // obsługa błędu HTTP 404
}

void loop() 
{
  Server.handleClient(); // czekaj na połączenia klientów
  MDNS.update();
}

String getTemperatureHumidit(bool debug)
{
  float temp = dht.readTemperature();
  float hmd = dht.readHumidity();

  if (debug)
  {
    Serial.print(F("Odczyt danych z czujnika DHT11 => T: "));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.println(F("%"));
  }

  String data = String(temp) + String(",") + String(hmd);
  return data; // zwróć wartość temperatury i wilgotności
}

// obsługa wywołania URL strony głównej
void handleRoot()
{
  Serial.println(F("=> Odebrano żądanie GET /"));
  Server.send(200, "text/html", page_index);
}

// obsługa wywołania URL do odczytu temperatury
void handleData()
{
  Serial.println(F("=> Odebrano żądanie GET /data"));
  String data = getTemperatureHumidit(true);
  Server.send(200, "text/plain", data);
}

// obsługa błędu HTTP 404
void handleNotFound() 
{
  String message = "404 Not Found\n\n";
  message += "The request ";
  message += Server.uri();
  message += " was not found on this server.\n";
  message += "\nMethod: ";
  message += (Server.method() == HTTP_GET) ? "GET" : "POST";
  message += "\nArguments: ";
  message += Server.args();
  message += "\n";
  for (int i = 0; i < Server.args(); i++)
  {
    message += " " + Server.argName(i) + ": " + Server.arg(i) + "\n";
  }
  Server.send(404, "text/plain", message);
}
