#include <SPI.h>    // dołącz obsługę interfejsu SPI,
#include <SD.h>     // czytnika kart SD,
#include "DHT.h"    // czujnika DHT,
#include "RTClib.h" // i modułu RTC

#define serialSpeed 115200 // prędkość transmisji UART

#define DHTPIN 7      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

#define SPI_SS 10 // numer GPIO dla linii SS (CS), 53 dla Mega 2560

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT,
File dataFile;            // czytnik kart SD,
RTC_DS1307 rtc;           // i moduł RTC

#define SET_RTC_DATE false // czy ustawić datę z daty kompilacji?

const long eventTime = 10000; // co ile milisekund aktualizować dane? (10s)
unsigned long previousTime = 0;

void setup() {
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czytnika modułu RTC ... "));
  if (!rtc.begin()) {
    Serial.println(F("wstąpił problem, nie znalazłem modułu :("));
    while (1);
  }
  Serial.println(F("gotowe!"));

  if (SET_RTC_DATE) {   
    // pobierz automatycznie datę i czas podczas kompilacji programu
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));

    // ustaw dowolny czas w formacie: rok, miesiąc, dzień, godzina, minuta, sekunda
    // rtc.adjust(DateTime(2022, 9, 7, 16, 15, 0));
  }  

  Serial.print(F("Inicjalizacja czytnika kart SD ... "));
  if (!SD.begin(SPI_SS)) { // uzyskaj dostęp do karty SD
    Serial.println(F("wstąpił problem, czy karta SD jest w czytniku?"));
    while (1); // włóż kartę SD do czytnika i uruchom program ponownie
  }
  Serial.println(F("gotowe!"));

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin(); // aktywuj odczyt z czujnika DHT
  Serial.println(F("gotowe!"));

  Serial.print(F("Aktualizacja danych co "));
  Serial.print(eventTime / 1000);
  Serial.println(F(" sekund."));  
}

void loop() {
  unsigned long currentTime = millis();

  if (currentTime - previousTime >= eventTime)
  {    
    previousTime = currentTime;

    String date = getDate();

    float temp = dht.readTemperature(); // odczyt temperatury
    float hmd = dht.readHumidity();     // i wilgotności

    Serial.print(date);
    Serial.print(F(",T:"));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.print(F("% | zapis danych na karcie SD ... "));
    
    updateFile(date, temp, hmd); // wywołaj funkcję zapisującą dane na kartę SD
    
    Serial.println(F("gotowe!"));
  }
}

void updateFile(String date, float temp, float hmd) {
    dataFile = SD.open("data.txt", FILE_WRITE); // otwórz (lub utwórz) plik do zapisu
    if (dataFile) { // jeśli dostęp do pliku jest możliwy, zapisz dane
      dataFile.print(date);
      dataFile.print(",");
      dataFile.print(temp);
      dataFile.print(",");
      dataFile.println(hmd);
    }
    dataFile.close(); // zamknij dostęp do pliku
}

String getDate() { // zwróć tekst z datą w formacie YYYY-MM-DD GG:MM:SS
  DateTime now = rtc.now(); // odczytaj aktualną datę i czas
  
  String date = "";
  date.concat(now.year());
  date.concat("-");
  date.concat(now.month());
  date.concat("-");
  date.concat(now.day());
  date.concat(" ");
  date.concat(now.hour());
  date.concat(":");
  date.concat(now.minute());
  date.concat(":");
  date.concat(now.second());

  return date;
}
