#include <ESP8266WiFi.h> // funkcje sieciowe dla układu ESP8266
// #include <WiFi.h>     // funkcje sieciowe dla układu ESP32
#include <aWOT.h>        // dołącz bibliotekę frameworku aWOT

WiFiServer Server(80);   // utwórz obiekt serwera WWW na porcie 80
Application app;         // i obiekt aplikacji obsługującej połączenia WWW

char authBuffer[200];    // bufor na HTTP Authorization

// definicja funkcji obsługujących trasy rutingu
void pageIndex(Request &req, Response &res) {
  res.set("Content-Type", "text/html");
  res.print(F("Ta strona dostępna jest na hasło!"));
}

void auth(Request &req, Response &res) {
  char * authHeader = req.get("Authorization");

  // czy wpisano poprawnie hasło?
  if (strcmp(authHeader, "Basic ZXNwOmVzcA==") != 0) { // esp:esp w base64
    res.set("WWW-Authenticate", "Basic realm=\"Podaj hasło dostępu\"");
    res.sendStatus(401);
    res.end();
  }
}

void setup() {
  Serial.begin(115200);

  WiFi.begin("nazwa sieci WiFi", "hasło");
  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(".");
  }
  Serial.println(WiFi.localIP());

  // definicja tras rutingu
  app.header("Authorization", authBuffer, 200); // obsłuż żądanie HTTP Authorization
  app.use(&auth);                               // funkcją auth()
  app.get("/", &pageIndex);                     // obsługa żądania GET / z hasłem
  
  Server.begin(); // uruchom serwer WWW
}

void loop() {
  WiFiClient client = Server.available();
  if (client.connected()) { // czekaj na połączenia klientów
    app.process(&client);   // obsłuż żądanie klienta
  }
}
