import machine
import network
import socket
import gc

gc.collect() # wyczyść pamięć ze zbędnych danych

# ustaw wyprowadzenia GPIO jako wejściowe (1 i 3 zarezerwowane dla UART)
pins = [machine.Pin(i, machine.Pin.IN) for i in (0, 2, 4, 5, 12, 13, 14, 15)]

# szablon kodu HTML strony WWW z odpowiedzią wysyłaną do klienta
html = """<!DOCTYPE html>
<html>
  <head>
    <title>ESP8266 GPIO</title>
  </head>
  <body>
    <h1>ESP8266 GPIO</h1>
    <table border="1">
      <tr><th>GPIO</th><th>Stan</th></tr>
      %s 
    </table>
  </body>
</html>
"""

# konfiguracja sieci WiFi
ssid = 'nazwa sieci WiFi'
password = 'hasło'

# połącz z siecią WiFi
station = network.WLAN(network.STA_IF)
station.active(True)
station.connect(ssid, password)

# czekaj na połączenie
while station.isconnected() == False:
    pass

# połączono z siecią, drukuj informacje o uzyskanym adresie IP
print('Połączono z siecią WiFi')
print(station.ifconfig())

# uruchom gniazdo TCP na porcie 80 i czekaj na połączenia klientów
sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.bind(('', 80))
sock.listen(5)

# obsługa klientów
while True:
  client, addr = sock.accept() # jeśli nastąpi połączenie, odczytaj dane klienta
  print('Połączenie klienta z adresu IP %s' % str(addr))

  # odczytaj zapytanie HTTP wysłane przez klienta
  # możesz informacje te wykorzystać do analizy zapytań HTTP
  request = client.recv(1024)
  request = str(request)
  
  # zaktualizuj szablon HTML o aktualne stany wyprowadzeń GPIO
  rows = ['<tr><td>%s</td><td>%d</td></tr>' % (str(p), p.value()) for p in pins]
  response = html % '\n'.join(rows)
  
  # wyślij dane do klienta (przeglądarki)
  client.send('HTTP/1.1 200 OK\n')
  client.send('Content-Type: text/html\n')
  client.send('Connection: close\n\n')
  client.sendall(response) # wyślij kod HTML
  client.close() # zamknij połączenie z klientem