#include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
#include <ESP8266HTTPClient.h> // obsługa klienta HTTP,
#include <OneWire.h>           // interfejsu 1-wire
#include <DallasTemperature.h> // i czujnika DS18B20
#include <ArduinoJson.h>       // dołącz obsługę formatu JSON

#define serialSpeed 115200     // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define ONE_WIRE_BUS 2          // czujnik DS18B20 podpięty do GPIO2
OneWire oneWire(ONE_WIRE_BUS);  // utwórz obiekt 1-wire
DallasTemperature ds(&oneWire); // do komunikacji z DS18B20

#define SERVER_IP    "192.168.1.110" // adres IP serwera TCP
#define SERVER_PORT  "80"            // port serwera TCP
#define SERVER_API   true            // czy korzystać z API?
#define SERVER_TOKEN "M75xrEgR8j3p"  // token do identyfikacji połączeń

#define BOARD_ID     "1"             // ID urządzenia w systemie

const long eventTime = 10000; // wysyłaj dane co 10 sekund
unsigned long previousTime = eventTime; // pierwszy pakiet wyślij po starcie programu

StaticJsonDocument<100> data; // zmienna tablicowa dla formatu JSON 

float temp = 0;

// obsługa klienta HTTP
WiFiClient wifiClient;
HTTPClient http;

void setup() 
{
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czujnika DS18B20 ... "));
  ds.begin();
  Serial.println(F("gotowe!"));

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  data["token"]    = SERVER_TOKEN;
  data["board_id"] = BOARD_ID;  
}

void loop() 
{
  unsigned long currentTime = millis();

  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    if (WiFi.status() == WL_CONNECTED) // sprawdź status połączenia
    {
      temp = getTemperature(true); // odczytaj wartość temperatury

      data["temp"] = temp;
      data["hmd"] = 0; // wysyłamy tylko dane o temperaturze

      String json = "";
      serializeJson(data, json); // przygotuj dane w formacie JSON

      // utwórz URL dla żądania HTTP GET
      String url = "http://";
      url.concat(SERVER_IP);
      url.concat(":");
      url.concat(SERVER_PORT);
      url.concat("/api.php?data=");
      url.concat(json);

      http.begin(wifiClient, url); // otwórz połączenie z serwerem

      int httpCode = http.GET(); // wywołaj żądanie HTTP GET
      if (httpCode > 0)
      {
        String status = http.getString();
        Serial.print("Status wysłania danych na serwer: ");
        Serial.println(status);
      }

      http.end(); // zamknij połączenie z serwerem
    }
  }
}

float getTemperature(bool debug)
{
  ds.requestTemperatures(); // wyślij żądanie odczytu temperatury
  float tempC = ds.getTempCByIndex(0); // odczytaj wartość temperatury

  if (tempC != DEVICE_DISCONNECTED_C) { // jeśli nie pojawił się błąd
    if (debug) {
      Serial.print(F("Odczyt temperatury z urządzenia nr 1 (indeks 0): "));
      Serial.print(tempC);
      Serial.println(F("°C"));
    }
  } else { // jeśli coś poszło nie tak
    if (debug) {
      Serial.println(F("Błąd odczytu danych z urządzenia nr 1"));
    }
  }

  return tempC; // zwróć wartość temperatury
}
