#include <ESP8266WiFi.h>       // funkcje sieciowe dla układu ESP8266
#include <ESP8266HTTPClient.h> // obsługa klienta HTTP,
#include "DHT.h"               // i czujnika DHT
#include <ArduinoJson.h>       // dołącz obsługę formatu JSON

#define serialSpeed 115200     // prędkość transmisji UART

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define DHTPIN 2      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

#define SERVER_IP    "192.168.1.110" // adres IP serwera TCP
#define SERVER_PORT  "80"            // port serwera TCP
#define SERVER_API   true            // czy korzystać z API?
#define SERVER_TOKEN "M75xrEgR8j3p"  // token do identyfikacji połączeń

#define BOARD_ID     "1"             // ID urządzenia w systemie

const long eventTime = 10000; // wysyłaj dane co 10 sekund
unsigned long previousTime = eventTime; // pierwszy pakiet wyślij po starcie programu

StaticJsonDocument<100> data; // zmienna tablicowa dla formatu JSON 

// obsługa klienta HTTP
WiFiClient wifiClient;
HTTPClient http;

// prosta struktura danych do przechowywania
// wartości temperatury i wilgotności
struct meas
{
  float temp;
  float hmd;
};

void setup() 
{
  Serial.begin(serialSpeed);

  Serial.print(F("Inicjalizacja czujnika DHT11 ... "));
  dht.begin();
  Serial.println(F("gotowe!"));

  // połącz z punktem dostępowym
  Serial.print(F("Łączę się z siecią WiFi "));
  WiFi.begin(wifi_ssid, wifi_passwd);

  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(F("."));
  }

  Serial.println(F(" gotowe!"));

  data["token"]    = SERVER_TOKEN;
  data["board_id"] = BOARD_ID;  
}

void loop() 
{
  unsigned long currentTime = millis();

  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    if (WiFi.status() == WL_CONNECTED) // sprawdź status połączenia
    {
      meas myMeas = getTemperatureHumidit(true);

      data["temp"] = myMeas.temp;
      data["hmd"] = myMeas.hmd;

      String json = "";
      serializeJson(data, json); // przygotuj dane w formacie JSON

      // utwórz URL dla żądania HTTP GET
      String url = "http://";
      url.concat(SERVER_IP);
      url.concat(":");
      url.concat(SERVER_PORT);
      url.concat("/api.php?data=");
      url.concat(json);

      http.begin(wifiClient, url); // otwórz połączenie z serwerem

      int httpCode = http.GET(); // wywołaj żądanie HTTP GET
      if (httpCode > 0)
      {
        String status = http.getString();
        Serial.print("Status wysłania danych na serwer: ");
        Serial.println(status);
      }

      http.end(); // zamknij połączenie z serwerem
    }
  }
}

meas getTemperatureHumidit(bool debug)
{
  float temp = dht.readTemperature();
  float hmd = dht.readHumidity();

  if (debug)
  {
    Serial.print(F("Odczyt danych z czujnika DHT11 => T: "));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.println(F("%"));
  }

  // wstaw wartości odczytów do struktury danych
  meas data;
  data.temp = temp;
  data.hmd = hmd;

  return data; // zwróć wartość temperatury i wilgotności
}
