<?php
date_default_timezone_set("Europe/Warsaw");

// czy zdefiniowano ID urządzenia?
if (!isset($_GET["board_id"])) {
    die();
}

$board_id = (int)$_GET["board_id"];
$board_id = max(min($board_id, 10), 1);

$interval = (isset($_GET["interval"])) ? (int)$_GET["interval"] : 1;
$interval = max(min($interval, 60), 1);

$cnt = (isset($_GET["cnt"])) ? (int)$_GET["cnt"] : 1;
$cnt = max(min($cnt, 60), 1);

$db_file = "database.db3";

if (!is_file(__DIR__.'/'.$db_file)) {
    print("Nie mogę otworzyć pliku ".$db_file.PHP_EOL);
    die();
}

try {
    $db_pdo = new PDO("sqlite:".__DIR__."/".$db_file);
    $db_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $db_pdo->prepare("SELECT temp, hmd, date FROM measurement WHERE board_id=:board_id AND date >= datetime('now', '-".$interval." minutes', 'localtime') ORDER BY id DESC LIMIT :cnt;");

    $stmt->bindValue(":board_id", $board_id, SQLITE3_INTEGER);
    $stmt->bindValue(":cnt", $cnt, SQLITE3_INTEGER);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $rows = array_reverse($rows);
    print(json_encode($rows));
    $db_pdo = NULL;

} catch (PDOException $e) {
    print("Błąd!: ".$e->getMessage());
    die();
}