#include <ESP8266WiFi.h> // funkcje sieciowe dla układu ESP8266
// #include <WiFi.h>     // funkcje sieciowe dla układu ESP32
#include <aWOT.h>        // dołącz bibliotekę frameworku aWOT

WiFiServer Server(80);   // utwórz obiekt serwera WWW na porcie 80,
Application app;         // obiekt aplikacji obsługującej połączenia WWW
Router devices;          // i obiekt rutera

// definicja funkcji obsługujących trasy rutingu
void deviceIndex(Request &req, Response &res) {
  res.print(F("Strona startowa"));
}

void deviceList(Request &req, Response &res) {
  res.print(F("Lista urządzeń"));
}

void deviceAdd(Request &req, Response &res) {
  res.print(F("Dodaj urządzenie"));
}

void deviceDel(Request &req, Response &res) {
  res.print(F("Usuń urządzenie"));
}

void setup() {
  Serial.begin(115200);

  WiFi.begin("nazwa sieci WiFi", "hasło");
  while (WiFi.status() != WL_CONNECTED) { // czekaj na połączenie
    delay(500);
    Serial.print(".");
  }
  Serial.println(WiFi.localIP());

  // definicja tras rutingu
  devices.get("/", &deviceIndex);
  devices.get("/list", &deviceList);
  devices.get("/add", &deviceAdd);
  devices.get("/del", &deviceDel);

  /*
  zamontowanie rutera dla trasy głównej: /devices
  obsługiwane żądania URL: /device/, /device/list, /device/add, /device/del 
  */
  app.use("/devices", &devices);
  
  Server.begin(); // uruchom serwer WWW
}

void loop() {
  WiFiClient client = Server.available();
  if (client.connected()) { // czekaj na połączenia klientów
    app.process(&client);   // obsłuż żądanie klienta
  }
}
