#include <SoftwareSerial.h> // dołącz obsługę UART dla pozostałych wyprowadzeń
#include <ArduinoJson.h>    // dołącz obsługę formatu JSON
#include "DHT.h"            // i czujnika DHT

#define serialSpeed 115200 // prędkość transmisji UART
#define DEBUG false        // true drukuje otrzymane dane z UART

SoftwareSerial esp8266(2,3); // RX, TX

char wifi_ssid[]   = "nazwa sieci WiFi";
char wifi_passwd[] = "hasło";

#define SERVER_IP    "192.168.1.110" // adres IP serwera TCP
#define SERVER_PORT  "80"            // port serwera TCP
#define SERVER_API   true            // czy korzystać z API?
#define SERVER_TOKEN "M75xrEgR8j3p"  // token do identyfikacji połączeń

#define BOARD_ID     "1"             // ID urządzenia w systemie

const long eventTime = 60000; // 60 sekund
unsigned long previousTime = eventTime; // pierwszy pakiet wyślij po starcie programu

StaticJsonDocument<100> data; // zmienna tablicowa dla formatu JSON

#define DHTPIN 7      // numer GPIO dla linii sygnałowej DAT w DHT11
#define DHTTYPE DHT11 // typ czujnika DHT
/*
#define DHTTYPE DHT21 // DHT 21 (AM2301)
#define DHTTYPE DHT22 // DHT 22 (AM2302), AM2321
*/

DHT dht(DHTPIN, DHTTYPE); // obiekt obsługujący czujnik DHT

void setup() 
{
  // prędkość komunikacji na interfejsach UART
  Serial.begin(serialSpeed);
  esp8266.begin(serialSpeed); 

  Serial.print(F("Inicjalizacja czujnika DHT ... "));
  dht.begin(); // aktywuj odczyt z czujnika DHT
  Serial.println(F("gotowe!"));

  Serial.println(F("Inicjalizacja modułu WiFi"));
  InitWifiModule(); // aktywuj moduł WiFi w trybie klienta
  Serial.println(F("Moduł gotowy do wysyłania danych na platformę IoT ..."));

  Serial.print(F("Aktualizacja danych co "));
  Serial.print(eventTime / 1000);
  Serial.println(F(" sekund."));

  data["token"]    = SERVER_TOKEN;
  data["board_id"] = BOARD_ID;  
}

void loop() 
{
  unsigned long currentTime = millis();

  if (currentTime - previousTime >= eventTime)
  { 
    previousTime = currentTime;

    float temp = dht.readTemperature();
    float hmd = dht.readHumidity();

    Serial.print(F("T: "));
    Serial.print(temp);
    Serial.print(F("°C, H: "));
    Serial.print(hmd);
    Serial.print(F("% | wysyłam dane na platformę IoT ... "));

    data["temp"] = temp;
    data["hmd"] = hmd;

    String json = "";
    serializeJson(data, json); // przygotuj dane w formacie JSON
    // Serial.println(json);

    // wyślij dane na serwer TCP
    updateTCPServer(SERVER_IP, SERVER_PORT, json, SERVER_API);

    Serial.println(F("gotowe!"));
  }
}

void updateTCPServer(String server_ip, String server_port, String json, bool api)
{
  // przygotuj polecenie do połączenia się z serwerem TCP
  String tcp = "AT+CIPSTART=\"TCP\",\"";
  tcp.concat(server_ip);
  tcp.concat("\",");
  tcp.concat(server_port);
  tcp.concat("\r\n");

  // otwórz połączenie TCP z serwerem
  sendData(&tcp, 3000, DEBUG);

  // przygotuj żądanie GET z parametrami czujników poprzez API
  String request = "";
  if (api) {
    request.concat("GET /api.php?data=");
    request.concat(json);
    request.concat(" HTTP/1.1\r\n");
    request.concat("Connection: Close\r\n");
  } else { // lub bez API
    request.concat(json);
  }
  request.concat("\r\n");

  // przygotuj dane do wysłania na serwer
  String cipSend = "AT+CIPSEND=";
  cipSend.concat(request.length());
  cipSend.concat("\r\n");
  sendData(&cipSend, 1000, DEBUG);

  // wyślij dane na serwer
  sendData(&request, 3000, DEBUG);
}

void InitWifiModule()
{
  String command = "";
  // sendData("AT+RESTORE\r\n", 2000, DEBUG); // przywrócenie ustawień domyślnych

  command = "AT+RST\r\n";
  sendData(&command, 2000, DEBUG); // reset modułu WiFi
  
  Serial.println(F("=> Ustawiam moduł w trybie klienta."));
  command = "AT+CWMODE=1\r\n";
  sendData(&command, 1500, DEBUG); // tryb klienta

  // przygotuj polecenie do połaczenia się z siecią WiFi
  Serial.println(F("=> Łączę moduł z siecią WiFi."));
  String cwjap = "AT+CWJAP=\"";
  cwjap.concat(wifi_ssid);
  cwjap.concat("\",\"");
  cwjap.concat(wifi_passwd);
  cwjap.concat("\"\r\n");
  sendData(&cwjap, 3000, DEBUG); // połącz z siecią WiFi

  delay(5000); // poczekaj, aż moduł WiFi połączy się z punktem dostępowym
}

String sendData(String *command, const int timeout, boolean debug)
{
    String response = ""; 
    esp8266.print(*command); // wyślij komendę AT do modułu WiFi
    long int time = millis();
    while( (time + timeout) > millis()) // poczekaj chwilę na odpowiedź
    {
      while(esp8266.available()) // jeśli pojawią się dane na interfejsie UART,
      {
        char c = esp8266.read(); // wstaw je do zmiennej
        response += c;
      }
    }
    if(debug) // jeśli DEBUG = true wydrukuj otrzymane dane
    {
      Serial.print(response);
    }

    // odczekaj chwilę, aby moduł WiFi przygotował się do następnej komendy AT
    delay(1000);

    return response; // zwróć odebrane dane
}
