#include <EEPROM.h> // obsługa pamięci EEPROM

void setup(){
  Serial.begin(115200); // inicjalizacja portu szeregowego

  int sizeEEPROM = EEPROM.length(); // odczytaj wielkość pamięći EEPROM
  Serial.print("Wielkość pamięci EEPROM na płytce: ");
  Serial.print(sizeEEPROM);
  Serial.println(" bajtów.");

  int address = 0; // początkowy adres w pamięci
  int value1, value2;

  for (int i = 0; i <= 10; i++)
  {
    // wariant 1
    // odczyt i zapis poprzez identyfikator
    value1 = EEPROM[address]; // odczytaj wartość
    EEPROM[address] = i;      // zapisz wartość
    value2 = EEPROM[address]; // ponownie odczytaj
     
    // wariant 2
    // odczyt i zapis z użyciem EEPROM.write()
    value1 = EEPROM.read(address); // odczytaj wartość
    EEPROM.write(address, i);      // zapisz wartość
    value2 = EEPROM.read(address); // ponownie odczytaj
    
    // wariant 3 (bezpieczny)
    // odczyt i zapis z użyciem EEPROM.update()
    value1 = EEPROM.read(address); // odczytaj wartość
    EEPROM.update(address, i);     // zaktualizuj, jeśli jest to wymagane
    value2 = EEPROM.read(address); // ponownie odczytaj

    // drukuj wartość komórki przed i po zmianą
    Serial.print(address);
    Serial.print("\t");
    Serial.print(value1);
    Serial.print("\t");
    Serial.println(value2);

    address++; // zwiększ adres o 1 z każdym cyklem pętli

    delay(1000); // odczekaj 1 sekundę
  }
}

void loop() {}
