IF OBJECT_ID('SalesLT.CorrectDates','TR') IS NOT NULL
   DROP TRIGGER SalesLT.CorrectDates;
GO
CREATE TRIGGER SalesLT.CorrectDates ON SalesLT.SalesOrderDetail
FOR INSERT, UPDATE
AS
  IF EXISTS (SELECT * FROM inserted AS i
                      JOIN SalesLT.Product AS p ON i.ProductID = p.ProductID
                      WHERE p.SellEndDate < getdate())
  BEGIN
    RAISERROR ('Produkt nie jest ju dostpny.', 16, 1);
    ROLLBACK TRANSACTION;
  RETURN 
END;
GO
