/* getCreditPrice:
 * Oblicza cen produktu, jeli jest on nabywany na raty
 */
CREATE PROC SalesLT.getCreditPrice
  @id int,                          -- SalesLT.Product.ProductId
  @rate real,                       -- Miesiczna stopa procentowa
  @months int = 12,                 -- Liczba miesicy
  @listPrice money OUTPUT,
  @price money OUTPUT
AS
  DECLARE @fee money;               -- Definicja zmiennej lokalnej, ktra zlicza opaty
  SET @price = (
    SELECT ListPrice FROM SalesLT.Product
    WHERE ProductID = @id);
  SET @listPrice = @price;
  SET @fee = CASE                   -- Opaty zale od ceny produktu
    WHEN @price < 10.0 THEN 0.50
    WHEN @price < 50.0 THEN 1.00
    ELSE                    2.00
  END;
  IF (@months >= 24) BEGIN          -- Jeeli okres spaty rat przekracza dwa lata, opaty zwikszaj si dwukrotnie
    SET @fee *= 2;
  END
  WHILE (@months > 0) BEGIN         -- Obliczenie procentu zwykego i skadanego
    SET @price = @price * (1+@rate);
    SET @months -= 1;
  END
  SET @price += @fee;
GO