<?php
//namespace net\xmp\phpbook;

class DatabaseConnection {

    public $handle = null;
    protected $serverName = '(local)';
    protected $connectionInfo = array(
        'Database' => 'AdventureWorksLT2008',
        'CharacterSet' => 'UTF-8'
    );

    /**
     * Establishes a connection with SQL.
     * Uses predefined connection parameters.
     */
    function connect() {
        $this->handle = sqlsrv_connect($this->serverName, $this->connectionInfo);
        if ($this->handle === false) {
            $this->exitWithError('database connection failed');
        }
    }

    /**
     * Disconnects the SQL Server connection.
     */
    function close() {
        if ($this->handle) {
            sqlsrv_close($this->handle);
            $this->handle = null;
        }
    }

    /**
     * Closes the program, returns error messages from SQL Server
     *
     * @param string $txt Error description
     */
    function exitWithError($txt) {
        $errors = sqlsrv_errors();
        $html = new HTMLPage('Database error');
        $html->addElement('p', $txt);
        $table = array(array('SQL status', 'Code', 'Message'));
        foreach ($errors as $error) {
            // Error messages have the ISO-8859-1 format
            $msg = iconv('ISO-8859-1', 'UTF-8', $error['message']);
            $table[] = array($error['SQLSTATE'], $error['code'], $msg);
        }
        $html->addTable($table);
        $html->printPage();
        $this->close();
        exit;
    }

}
?>
