<?php
namespace net\xmp\phpbook; 
require './HTMLPage.php'; 
require './LDAPConnection.php'; 
$html = new HTMLPage('LDAP User Search'); 
 
// Podczenie
$ad = new LDAPConnection(); 
$ad->connect('doco-exch.xmp.site', 'arno@xmp.site', 'confidential'); 
// Wyszukiwanie uytkownikw 
$baseDN = "CN=users,DC=xmp,DC=site"; 
// Filtr wyszukuje obiekty uytkownikw korzystajc z atrybutu userPrincipalName
$filter = "(&(objectcategory=Person)(userPrincipalName=*))"; 
// Definicja atrybutw do pobrania
$attributes = array('name', 'userPrincipalName', 'sAMAccountName'); 
// Rozpoczcie wyszukiwania
$qresult = ldap_search($ad->handle, $baseDN, $filter, $attributes); 
if (!$qresult) { 
    $ad->exitWithError('Wyszukiwanie LDAP nieudane.'); 
} 
// Pobieranie obiektw ... 
$entries = ldap_get_entries($ad->handle, $qresult); 
if (!$entries) { 
    $ad->exitWithError('Odczyt LDAP nieudany.');
}
// ... i zapisanie tablicy
$table = array(array('Name', 'Principal', 'DN', 'Account Name')); 
for ($i = 0; $i < $entries['count']; $i++) { 
    $table[] = array($entries[$i]['name'][0], $entries[$i]['userprincipalname'][0], 
                     $entries[$i]['dn'], $entries[$i]['samaccountname'][0]); 
} 
$html->addTable($table); 
 
// Udostpnienie wyniku zamknicie poczenia
ldap_free_result($qresult); 
$ad->close(); 
$html->printPage(); 
?>
