<?php
namespace net\xmp\phpbook;
require './DatabaseConnection.php';
require './HTMLPage.php';
require './search_products_db.php';

$html = new HTMLPage('AdventureWorks : Wyszukiwanie produktów');
$form = <<<EOF
<form action="" method="get">
Nazwa produktu: <input name="product" />
<input type="submit" value="Szukaj" />
</form><br />
EOF;
$html->addHTML($form);
if (isset($_GET['product'])) {
    $name = sanitizeName($_GET['product']);
    $products = getProductsByName($name);
    if ($products) {
        addImageColumn($products);
        $html->addTable($products, array(false, false, false, true));
    } else {
        $html->addElement('p', 'Nie znaleziono produktu.');
    }
}
$html->printPage();
exit;

function sanitizeName($txt) { ... } // Kod taki sam jak wcześniej

/**
 * Dodanie do tabeli miniaturki zdjęcia produktu.
 */
function addImageColumn(&$products) {
    $products[0][] = 'Zdjęcie ';
    for ($i = 1; $i < count($products); $i++) {
        $products[$i][] = '<img src="get_image.php?id='
                        . $products[$i][0]
                        . '" alt="Zdjęcie produktu" />';
    }
}
?>
