class LDAPConnection {
 
    // ... 
    public $baseDN = ''; 
    // ... 
 
    /** 
     * Pobieranie obiektu z nazw konta SAM
     * @param string $account Nazwa konta SAM
     * @param array $attributes dane atrybuty
     * @param string $baseDN Gwna nazwa DN dla wyszukiwania
     */ 
    function getAccount($account, $attributes=array(), $baseDN='') { 
        $filter = '(sAMAccountName=' . escapeLDAP($account) . ')'; 
        $account = $this->getOneEntry($filter, $attributes, $baseDN); 
        if (!$account) { 
            $this->exitWithError('Konto nie zostao znalezione.'); 
        } 
        return $account; 
    } 
 
    /** 
     * Pobieranie wyszukanego obiektu 
     * @param string $filter Cig filtra 
     * @param array $attributes dane atrybuty
     * @param string $baseDN Gwna nazwa DN dla wyszukiwania
     */ 
    function getOneEntry($filter, $attributes=array(), $baseDN='') { 
        if (empty($baseDN)) { 
            $baseDN = $this->baseDN; 
        } 
        $result = ldap_search($this->handle, $baseDN, $filter, $attributes); 
        if (!$result) { 
            return false; 
        } 
        $entry = ldap_first_entry($this->handle, $result); 
        if (!$entry) { 
            return false; 
        } 
        $attr = ldap_get_attributes($this->handle, $entry); 
        if (!$attr) { 
            return false; 
        } 
        $attr['dn'] = ldap_get_dn($this->handle, $entry); 
        return $attr; 
    } 
}
