﻿<?php
namespace net\xmp\phpbook;

require './DatabaseConnection.php';
require './HTMLPage.php';
require './search_products_db.php';

$html = new HTMLPage('AdventureWorks : Wyszukiwanie produktów');
$form = <<<EOF
<form action="" method="get">
Nazwa produktu: <input name="product" />
<input type="submit" value="Szukaj" />
</form><br />
EOF;
$html->addHTML($form);
if (isset($_GET['product'])) {
    $name = sanitizeName($_GET['product']);
    $products = getProductsByName($name);
    if ($products) {
        $html->addTable($products);
    } else {
        $html->addElement('p', 'Nie znaleziono produktu.');
    }
}
$html->printPage();
exit;

/**
 * Sprawdzenie, czy ciąg znaków jest prawidłowo zakodowany oraz odfiltrowanie niepożądanych znaków.
 */
function sanitizeName($txt) {
    if (!mb_check_encoding($txt, 'UTF-8')) {
        die('Błędne kodowanie wartości wejściowej.');
    }
    mb_regex_encoding('UTF-8');
    return mb_ereg_replace("[^-[:alnum:]',  ]", '', $txt);
}
?>
