SELECT soh.SalesOrderID, soh.TotalDue,
       p.Name, sod.LineTotal, sod.LineTotal/soh.SubTotal*100 AS PercentOfSubTotal
FROM SalesLT.SalesOrderHeader AS soh
JOIN SalesLT.SalesOrderDetail AS sod ON sod.SalesOrderID = soh.SalesOrderID
JOIN SalesLT.Product AS p ON p.ProductID = sod.ProductID
WHERE sod.OrderQty =
     ( SELECT max(sod2.OrderQty)
       FROM SalesLT.SalesOrderDetail as sod2
       WHERE sod2.SalesOrderID = sod.SalesOrderID
     );
GO
