<?php
namespace net\xmp\phpbook; 
 
require './HTMLPage.php'; 
require './LDAPConnection.php'; 
require './browse_ldap_types.php'; 
require './LDAPEntryFormatter.php'; 
require './AD_util.php'; 
// Zaadowanie skryptu wprowadzajcego zmiany 
require './________.php'; 
 
$html = new HTMLPage('Zapisywanie do Active Directory'); 
// Zestawianie poczenia
$ad = new LDAPConnection(); 
$ad->connect('doco-exch.xmp.site', 'administrator@xmp.site', 'confidential'); 
$ad->baseDN = 'DC=xmp,DC=site'; 
 
// Wprowadzenie zmian
$before = $ad->getAccount($accountName, $attributes); 
modify($ad, $before); 
$after= $ad->getAccount($accountName, $attributes); 
 
// Wywietlenie zmian
$table = formatChangedEntry($before, $after); 
$html->addElement('h2', $before['dn']); 
$html->addTable($table, array(true, true, true)); 
$html->printPage(); 
function formatChangedEntry($beforeEntry, $afterEntry)
{ 
    // Formatowanie obiektu
    $bf = new LDAPEntryFormatter($beforeEntry, 'object', 'browse_ldap.php'); 
    $beforeHTML = $bf->getAttributes(); 
    $af = new LDAPEntryFormatter($afterEntry, 'object', 'browse_ldap.php'); 
    $afterHTML = $af->getAttributes(); 
    // czenie obiektw
    $values = array(); 
    for ($i=1; $i<count($beforeHTML); $i++) { 
        $values[$beforeHTML[$i][0]]['before'] = $beforeHTML[$i][1]; 
    } 
    for ($i=1; $i<count($afterHTML); $i++) { 
        $values[$afterHTML[$i][0]]['after'] = $afterHTML[$i][1]; 
    } 
    $table = array( array('Atrybut', 'Przed', 'Po') ); 
    $notset = '<i>nie ustawiony</i>'; 
    foreach ($values as $attribute => $value) { 
        $before = isset($value['before']) ? $value['before'] : $notset; 
        $after = isset($value['after']) ? $value['after'] : $notset; 
        $table[] = array($attribute, $before, $after); 
    } 
    return $table; 
} 
?>
