﻿# kodowanie: ASCII-8BIT
#!/usr/bin/env ruby
require 'metasm'
include Metasm

# Generuje kod procedury obsługi architektury x86.
sc = Metasm::Shellcode.assemble(Metasm::Ia32.new, <<EOS)
entry:
    mov ecx, 1
    shl ecx, 0xA
    add edx, 0xBADC0FFE
    mov eax, 0x100000
    lea eax, [ecx+eax]
    add ecx, 0xBADC0FFE
    jmp eax
EOS

# Kod procedury deasemblera.
dasm = sc.init_disassembler
dasm.disassemble(0)

# Uzyskaj dostęp do podstawowego bloku.
bb = dasm.block_at(0)
puts "[+] podstawowy blok:"
puts bb.list

target = dasm.get_xrefs_x(bb.list.last).first
puts "\n[+] cel analizowanego skoku: #{target}\n\n"

# przeglądanie z powrotami
values = dasm.backtrace(target, bb.list.last.address,
    {:log => bt_log = [], :include_start => true})
bt_log.each{|entry|
    case type = entry.first
    when :start
        entry, expr, addr = entry
        puts "[start] przegladanie z powrotem wyrazenia #{expr} z 0x#{addr.to_s(16)}"

    when :di
        entry, to, from, instr = entry
        puts "[aktualizacja] instrukcja #{instr},\n  -> aktualizacja wyrazenia od#{from} do#{to}\n"

    when :found
        entry, final = entry
        puts "[znaleziono] mozliwa wartosc: #{final.first}\n"

    when :up
        entry, to, from, addr_down, addr_up = entry
        puts "[wyzej] adres 0x#{addr_down.to_s(16)} -> 0x#{addr_up.to_s(16)}"
    end
}

# Obiekt OdkodowanaInstrukcja jest trzecim elementem: identyfikator elementu
slice = bt_log.select{|e| e.first==:di}.map{|e| e[3]}.reverse
puts "\n[+] rozdzielanie:"
puts slice

