# kodowanie: ASCII-8BIT
#!/usr/bin/env ruby

require 'metasm'
include Metasm

$SPAWN_GUI = false
CODE_BASE_ADDR = 0x10000000
HTABLE_BASE_ADDR = 0x18000000
DATA_BASE_ADDR = 0x1a000000
INJECT_MAX_ITER = 0x20
NATIVE_REGS = [:eax, :edx, :ecx, :ebx, :esp, :ebp, :esi, :edi]

def display(bd)
    bd.each{|key,value| puts "  #{Expression[key]} => #{Expression[value]}"}
end

# Generuje kod procedury obsugi architektury x86.
sc = Metasm::Shellcode.assemble(Metasm::Ia32.new, <<EOS)
lodsd
mov ecx, eax
xor ecx, ebp
movzx eax, cl
push eax
mov eax, [edi+eax]

movzx edx, ch
mov edx, [edi+edx]
xor eax, edx

pop edx
mov [edi+edx], eax

lodsd
xor ebp, 0x35ef6a14
xor eax, ebp
jmp [#{HTABLE_BASE_ADDR}+eax*4]
EOS

handler = sc.encode_string

# szesnastkowy kod sekcji danych
data_section_hex = "\xA3\xCB\xDB\x5F\x60\xBD\x34\x6A"

# Dodaj sekcj kodu.
dasm = sc.init_disassembler
dasm.add_section(EncodedData.new(handler), CODE_BASE_ADDR)

# Dodaj sekcj danych.
dasm.add_section(EncodedData.new(data_section_hex), DATA_BASE_ADDR)

# Deasembluj kod procedury.
dasm.disassemble_fast_deep(CODE_BASE_ADDR)

if $SPAWN_GUI
    Gui::DasmWindow.new("metasm - symbolic-execution-lvl2", dasm, [CODE_BASE_ADDR])
    dasm.load_plugin('hl_opcode') # hilight jmp/call instrs
    dasm.gui.focus_addr(dasm.gui.curaddr, :graph) # start in graph mode
    Gui.main
end

=begin

Pytanie 1:

Poprzednia prbka kodu bya tylko prbk, niedziaajcym kodem.
Okrel semantyk procedury.

=end

# Okrel semantyk procedury.

puts "\n=== Pytanie 1 ==="


=begin

Pytanie 2:

Dla pierwszego wywoania maszyny wirtualnej inicjalizowany jest nastpujcy kontekst:
  pushad
  mov edi, esp

Maszyna wirtualna korzysta z kodu o zmiennej wartoci, ktra jest zapisywana w rejestrze ebp.

Odtwrz mapowanie pomidzy kontekstem maszyny wirtualnej, a kodem semantyki.

=end

puts "\n=== Pytanie 2 ==="


=begin

Pytanie 3:

Oto kontekst maszyny wirtualnej przed uruchomieniem procedury:
context = {
  :nhandler => 0x84,
  :vmkey => 0x5fdbd7b7,
  virt_ecx => 0,
  virt_edx => 0x41414141,
  virt_ebx => 1,
  :virt_edi => :virt_edi,
  :virt_esi => DATA_BASE_ADDR,
}

Okrel efekt uruchomienia procedury.

Problemy:
  - Jak uzyskuje si dostp do danych programu?

=end

puts "\n=== Pytanie 3 ==="


=begin

Pytanie 4 (dodatkowe):

Jak moemy odtworzy cz pierwotnego kodu?

=end

puts "\n=== Pytanie 4 ==="
